/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.rest.history;

import java.util.Date;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.guacamole.net.auth.ActivityLog;
import org.apache.guacamole.net.auth.ActivityRecord;
import org.apache.guacamole.rest.history.APIActivityLog;

public class APIActivityRecord {
    private final Date startDate;
    private final Date endDate;
    private final String remoteHost;
    private final String username;
    private final boolean active;
    private final String identifier;
    private final UUID uuid;
    private final Map<String, String> attributes;
    private final Map<String, APIActivityLog> logs;

    public APIActivityRecord(ActivityRecord record) {
        this.startDate = record.getStartDate();
        this.endDate = record.getEndDate();
        this.remoteHost = record.getRemoteHost();
        this.username = record.getUsername();
        this.active = record.isActive();
        this.identifier = record.getIdentifier();
        this.uuid = record.getUUID();
        this.attributes = record.getAttributes();
        this.logs = record.getLogs().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new APIActivityLog((ActivityLog)entry.getValue())));
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public String getUsername() {
        return this.username;
    }

    public boolean isActive() {
        return this.active;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public Map<String, APIActivityLog> getLogs() {
        return this.logs;
    }
}

