/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.spark;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.spark.sql.sources.v2.DataSourceOptions;

public class SparkCaseSensitiveConverter {
    private static final Set<String> CASE_SENSITIVE_KEYS = new HashSet<String>();
    private static final String ACCESS_KEY_ID = "fs.oss.accessKeyId";
    private static final String ACCESS_KEY_SECRET = "fs.oss.accessKeySecret";
    private static final String SECURITY_TOKEN = "fs.oss.securityToken";

    public static Map<String, String> convert(DataSourceOptions options) {
        HashMap<String, String> newOptions = new HashMap<String, String>(options.asMap());
        CASE_SENSITIVE_KEYS.forEach(key -> {
            String lowercaseKey = key.toLowerCase();
            if (newOptions.containsKey(lowercaseKey)) {
                newOptions.put((String)key, (String)newOptions.remove(lowercaseKey));
            }
        });
        return newOptions;
    }

    static {
        CASE_SENSITIVE_KEYS.add(ACCESS_KEY_ID);
        CASE_SENSITIVE_KEYS.add(ACCESS_KEY_SECRET);
        CASE_SENSITIVE_KEYS.add(SECURITY_TOKEN);
    }
}

