/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.typeutils;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.core.memory.MemorySegmentWritable;
import org.apache.flink.runtime.memory.AbstractPagedInputView;
import org.apache.flink.runtime.memory.AbstractPagedOutputView;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.data.binary.BinarySegmentUtils;
import org.apache.flink.table.runtime.typeutils.AbstractRowDataSerializer;
import org.apache.flink.util.Preconditions;

@Internal
public class BinaryRowDataSerializer
extends AbstractRowDataSerializer<BinaryRowData> {
    private static final long serialVersionUID = 1L;
    public static final int LENGTH_SIZE_IN_BYTES = 4;
    private final int numFields;
    private final int fixedLengthPartSize;

    public BinaryRowDataSerializer(int numFields) {
        this.numFields = numFields;
        this.fixedLengthPartSize = BinaryRowData.calculateFixPartSizeInBytes(numFields);
    }

    @Override
    public boolean isImmutableType() {
        return false;
    }

    @Override
    public TypeSerializer<BinaryRowData> duplicate() {
        return new BinaryRowDataSerializer(this.numFields);
    }

    @Override
    public BinaryRowData createInstance() {
        return new BinaryRowData(this.numFields);
    }

    @Override
    public BinaryRowData copy(BinaryRowData from) {
        return this.copy(from, new BinaryRowData(this.numFields));
    }

    @Override
    public BinaryRowData copy(BinaryRowData from, BinaryRowData reuse) {
        return from.copy(reuse);
    }

    @Override
    public int getLength() {
        return -1;
    }

    @Override
    public void serialize(BinaryRowData record, DataOutputView target) throws IOException {
        target.writeInt(record.getSizeInBytes());
        if (target instanceof MemorySegmentWritable) {
            BinaryRowDataSerializer.serializeWithoutLength(record, (MemorySegmentWritable)((Object)target));
        } else {
            BinarySegmentUtils.copyToView(record.getSegments(), record.getOffset(), record.getSizeInBytes(), target);
        }
    }

    @Override
    public BinaryRowData deserialize(DataInputView source) throws IOException {
        BinaryRowData row = new BinaryRowData(this.numFields);
        int length = source.readInt();
        byte[] bytes = new byte[length];
        source.readFully(bytes);
        row.pointTo(MemorySegmentFactory.wrap(bytes), 0, length);
        return row;
    }

    @Override
    public BinaryRowData deserialize(BinaryRowData reuse, DataInputView source) throws IOException {
        MemorySegment[] segments = reuse.getSegments();
        Preconditions.checkArgument(segments == null || segments.length == 1 && reuse.getOffset() == 0, "Reuse BinaryRowData should have no segments or only one segment and offset start at 0.");
        int length = source.readInt();
        if (segments == null || segments[0].size() < length) {
            segments = new MemorySegment[]{MemorySegmentFactory.wrap(new byte[length])};
        }
        source.readFully(segments[0].getArray(), 0, length);
        reuse.pointTo(segments, 0, length);
        return reuse;
    }

    @Override
    public int getArity() {
        return this.numFields;
    }

    @Override
    public BinaryRowData toBinaryRow(BinaryRowData rowData) throws IOException {
        return rowData;
    }

    @Override
    public int serializeToPages(BinaryRowData record, AbstractPagedOutputView headerLessView) throws IOException {
        Preconditions.checkArgument(headerLessView.getHeaderLength() == 0);
        int skip = this.checkSkipWriteForFixLengthPart(headerLessView);
        headerLessView.writeInt(record.getSizeInBytes());
        BinaryRowDataSerializer.serializeWithoutLength(record, headerLessView);
        return skip;
    }

    private static void serializeWithoutLength(BinaryRowData record, MemorySegmentWritable writable) throws IOException {
        if (record.getSegments().length == 1) {
            writable.write(record.getSegments()[0], record.getOffset(), record.getSizeInBytes());
        } else {
            BinaryRowDataSerializer.serializeWithoutLengthSlow(record, writable);
        }
    }

    public static void serializeWithoutLengthSlow(BinaryRowData record, MemorySegmentWritable out) throws IOException {
        int remainSize = record.getSizeInBytes();
        int posInSegOfRecord = record.getOffset();
        int segmentSize = record.getSegments()[0].size();
        for (MemorySegment segOfRecord : record.getSegments()) {
            int nWrite = Math.min(segmentSize - posInSegOfRecord, remainSize);
            assert (nWrite > 0);
            out.write(segOfRecord, posInSegOfRecord, nWrite);
            posInSegOfRecord = 0;
            if ((remainSize -= nWrite) == 0) break;
        }
        Preconditions.checkArgument(remainSize == 0);
    }

    @Override
    public BinaryRowData deserializeFromPages(AbstractPagedInputView headerLessView) throws IOException {
        return this.deserializeFromPages(this.createInstance(), headerLessView);
    }

    @Override
    public BinaryRowData deserializeFromPages(BinaryRowData reuse, AbstractPagedInputView headerLessView) throws IOException {
        Preconditions.checkArgument(headerLessView.getHeaderLength() == 0);
        this.checkSkipReadForFixLengthPart(headerLessView);
        return this.deserialize(reuse, (DataInputView)headerLessView);
    }

    @Override
    public BinaryRowData mapFromPages(BinaryRowData reuse, AbstractPagedInputView headerLessView) throws IOException {
        Preconditions.checkArgument(headerLessView.getHeaderLength() == 0);
        this.checkSkipReadForFixLengthPart(headerLessView);
        this.pointTo(headerLessView.readInt(), reuse, headerLessView);
        return reuse;
    }

    @Override
    public void skipRecordFromPages(AbstractPagedInputView headerLessView) throws IOException {
        Preconditions.checkArgument(headerLessView.getHeaderLength() == 0);
        this.checkSkipReadForFixLengthPart(headerLessView);
        headerLessView.skipBytes(headerLessView.readInt());
    }

    public void copyFromPagesToView(AbstractPagedInputView source, DataOutputView target) throws IOException {
        this.checkSkipReadForFixLengthPart(source);
        int length = source.readInt();
        target.writeInt(length);
        target.write(source, length);
    }

    public void pointTo(int length, BinaryRowData reuse, AbstractPagedInputView headerLessView) throws IOException {
        Preconditions.checkArgument(headerLessView.getHeaderLength() == 0);
        if (length < 0) {
            throw new IOException(String.format("Read unexpected bytes in source of positionInSegment[%d] and limitInSegment[%d]", headerLessView.getCurrentPositionInSegment(), headerLessView.getCurrentSegmentLimit()));
        }
        int remainInSegment = headerLessView.getCurrentSegmentLimit() - headerLessView.getCurrentPositionInSegment();
        MemorySegment currSeg = headerLessView.getCurrentSegment();
        int currPosInSeg = headerLessView.getCurrentPositionInSegment();
        if (remainInSegment >= length) {
            reuse.pointTo(currSeg, currPosInSeg, length);
            headerLessView.skipBytesToRead(length);
        } else {
            this.pointToMultiSegments(reuse, headerLessView, length, length - remainInSegment, currSeg, currPosInSeg);
        }
    }

    private void pointToMultiSegments(BinaryRowData reuse, AbstractPagedInputView source, int sizeInBytes, int remainLength, MemorySegment currSeg, int currPosInSeg) throws IOException {
        int div;
        int segmentSize = currSeg.size();
        int remainder = remainLength - segmentSize * (div = remainLength / segmentSize);
        int varSegSize = remainder == 0 ? div : div + 1;
        MemorySegment[] segments = new MemorySegment[varSegSize + 1];
        segments[0] = currSeg;
        for (int i = 1; i <= varSegSize; ++i) {
            source.advance();
            segments[i] = source.getCurrentSegment();
        }
        int remainLenInLastSeg = remainder == 0 ? segmentSize : remainder;
        source.skipBytesToRead(remainLenInLastSeg);
        reuse.pointTo(segments, currPosInSeg, sizeInBytes);
    }

    private int checkSkipWriteForFixLengthPart(AbstractPagedOutputView out) throws IOException {
        int available = out.getSegmentSize() - out.getCurrentPositionInSegment();
        if (available < this.getSerializedRowFixedPartLength()) {
            out.advance();
            return available;
        }
        return 0;
    }

    public void checkSkipReadForFixLengthPart(AbstractPagedInputView source) throws IOException {
        int available = source.getCurrentSegmentLimit() - source.getCurrentPositionInSegment();
        if (available < this.getSerializedRowFixedPartLength()) {
            source.advance();
        }
    }

    public int getSerializedRowFixedPartLength() {
        return this.getFixedLengthPartSize() + 4;
    }

    public int getFixedLengthPartSize() {
        return this.fixedLengthPartSize;
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        int length = source.readInt();
        target.writeInt(length);
        target.write(source, length);
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof BinaryRowDataSerializer && this.numFields == ((BinaryRowDataSerializer)obj).numFields;
    }

    @Override
    public int hashCode() {
        return Integer.hashCode(this.numFields);
    }

    @Override
    public TypeSerializerSnapshot<BinaryRowData> snapshotConfiguration() {
        return new BinaryRowDataSerializerSnapshot(this.numFields);
    }

    public static final class BinaryRowDataSerializerSnapshot
    implements TypeSerializerSnapshot<BinaryRowData> {
        private static final int CURRENT_VERSION = 3;
        private int previousNumFields;

        public BinaryRowDataSerializerSnapshot() {
        }

        BinaryRowDataSerializerSnapshot(int numFields) {
            this.previousNumFields = numFields;
        }

        @Override
        public int getCurrentVersion() {
            return 3;
        }

        @Override
        public void writeSnapshot(DataOutputView out) throws IOException {
            out.writeInt(this.previousNumFields);
        }

        @Override
        public void readSnapshot(int readVersion, DataInputView in, ClassLoader userCodeClassLoader) throws IOException {
            this.previousNumFields = in.readInt();
        }

        @Override
        public TypeSerializer<BinaryRowData> restoreSerializer() {
            return new BinaryRowDataSerializer(this.previousNumFields);
        }

        @Override
        public TypeSerializerSchemaCompatibility<BinaryRowData> resolveSchemaCompatibility(TypeSerializer<BinaryRowData> newSerializer) {
            if (!(newSerializer instanceof BinaryRowDataSerializer)) {
                return TypeSerializerSchemaCompatibility.incompatible();
            }
            BinaryRowDataSerializer newBinaryRowSerializer = (BinaryRowDataSerializer)newSerializer;
            if (this.previousNumFields != newBinaryRowSerializer.numFields) {
                return TypeSerializerSchemaCompatibility.incompatible();
            }
            return TypeSerializerSchemaCompatibility.compatibleAsIs();
        }
    }
}

