/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph.metrics;

import org.apache.flink.api.common.JobStatus;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.runtime.executiongraph.JobStatusProvider;
import org.apache.flink.util.Preconditions;

public class DownTimeGauge
implements Gauge<Long> {
    public static final String METRIC_NAME = "downtime";
    private static final long NOT_FAILING = 0L;
    private static final long NO_LONGER_RUNNING = -1L;
    private final JobStatusProvider jobStatusProvider;

    public DownTimeGauge(JobStatusProvider jobStatusProvider) {
        this.jobStatusProvider = Preconditions.checkNotNull(jobStatusProvider);
    }

    public Long getValue() {
        JobStatus status = this.jobStatusProvider.getState();
        if (status.isTerminalState()) {
            return -1L;
        }
        long runningTimestamp = this.jobStatusProvider.getStatusTimestamp(JobStatus.RUNNING);
        long failingTimestamp = this.jobStatusProvider.getStatusTimestamp(JobStatus.FAILING);
        if (failingTimestamp <= runningTimestamp) {
            return 0L;
        }
        return Math.max(System.currentTimeMillis() - failingTimestamp, 0L);
    }
}

