/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.base.BasicTypeComparator;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.types.StringValue;

@Internal
public final class StringComparator
extends BasicTypeComparator<String> {
    private static final long serialVersionUID = 1L;
    private static final int HIGH_BIT = 128;
    private static final int HIGH_BIT2 = 8192;
    private static final int HIGH_BIT2_MASK = 192;

    public StringComparator(boolean ascending) {
        super(ascending);
    }

    @Override
    public int compareSerialized(DataInputView firstSource, DataInputView secondSource) throws IOException {
        String s1 = StringValue.readString(firstSource);
        String s2 = StringValue.readString(secondSource);
        int comp = s1.compareTo(s2);
        return this.ascendingComparison ? comp : -comp;
    }

    @Override
    public boolean supportsNormalizedKey() {
        return true;
    }

    @Override
    public boolean supportsSerializationWithKeyNormalization() {
        return false;
    }

    @Override
    public int getNormalizeKeyLen() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean isNormalizedKeyPrefixOnly(int keyBytes) {
        return true;
    }

    @Override
    public void putNormalizedKey(String record, MemorySegment target, int offset, int len) {
        int limit = offset + len;
        int end = record.length();
        int pos = 0;
        while (pos < end && offset < limit) {
            char c;
            if ((c = record.charAt(pos++)) < '\u0080') {
                target.put(offset++, (byte)c);
                continue;
            }
            if (c < '\u2000') {
                target.put(offset++, (byte)(c >>> 7 | 0x80));
                if (offset >= limit) continue;
                target.put(offset++, (byte)c);
                continue;
            }
            target.put(offset++, (byte)(c >>> 10 | 0xC0));
            if (offset < limit) {
                target.put(offset++, (byte)(c >>> 2));
            }
            if (offset >= limit) continue;
            target.put(offset++, (byte)c);
        }
        while (offset < limit) {
            target.put(offset++, (byte)0);
        }
    }

    public StringComparator duplicate() {
        return new StringComparator(this.ascendingComparison);
    }
}

