/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.utils;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public class LocalFileUtils {
    public static Path getTargetPathIfContainsSymbolicPath(Path path) throws IOException {
        Path targetPath = path;
        Path suffixPath = Paths.get("", new String[0]);
        while (path != null && path.getFileName() != null) {
            if (Files.isSymbolicLink(path)) {
                Path linkedPath = path.toRealPath(new LinkOption[0]);
                targetPath = Paths.get(linkedPath.toString(), suffixPath.toString());
                break;
            }
            suffixPath = Paths.get(path.getFileName().toString(), suffixPath.toString());
            path = path.getParent();
        }
        return targetPath;
    }
}

