/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.spark;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SparkCaseSensitiveConverter {
    private static final Set<String> CASE_SENSITIVE_KEYS = new HashSet<String>();
    private static final String ACCESS_KEY_ID = "fs.oss.accessKeyId";
    private static final String ACCESS_KEY_SECRET = "fs.oss.accessKeySecret";
    private static final String SECURITY_TOKEN = "fs.oss.securityToken";

    public static Map<String, String> convert(Map<String, String> caseInsensitiveOptions) {
        HashMap<String, String> options = new HashMap<String, String>(caseInsensitiveOptions);
        CASE_SENSITIVE_KEYS.forEach(key -> {
            String lowercaseKey = key.toLowerCase();
            if (caseInsensitiveOptions.containsKey(lowercaseKey)) {
                options.put((String)key, (String)options.remove(lowercaseKey));
            }
        });
        return options;
    }

    private SparkCaseSensitiveConverter() {
    }

    static {
        CASE_SENSITIVE_KEYS.add(ACCESS_KEY_ID);
        CASE_SENSITIVE_KEYS.add(ACCESS_KEY_SECRET);
        CASE_SENSITIVE_KEYS.add(SECURITY_TOKEN);
    }
}

