/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.operation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.store.file.io.DataFileMeta;
import org.apache.flink.table.store.file.io.DataFilePathFactory;
import org.apache.flink.table.store.file.io.RowDataFileRecordReader;
import org.apache.flink.table.store.file.mergetree.compact.ConcatRecordReader;
import org.apache.flink.table.store.file.operation.FileStoreRead;
import org.apache.flink.table.store.file.predicate.Predicate;
import org.apache.flink.table.store.file.predicate.PredicateBuilder;
import org.apache.flink.table.store.file.schema.SchemaEvolutionUtil;
import org.apache.flink.table.store.file.schema.SchemaManager;
import org.apache.flink.table.store.file.schema.TableSchema;
import org.apache.flink.table.store.file.utils.BulkFormatMapping;
import org.apache.flink.table.store.file.utils.FileStorePathFactory;
import org.apache.flink.table.store.file.utils.RecordReader;
import org.apache.flink.table.store.format.FileFormat;
import org.apache.flink.table.store.table.source.DataSplit;
import org.apache.flink.table.store.utils.Projection;
import org.apache.flink.table.types.logical.RowType;

public class AppendOnlyFileStoreRead
implements FileStoreRead<RowData> {
    private final SchemaManager schemaManager;
    private final long schemaId;
    private final RowType rowType;
    private final FileFormat fileFormat;
    private final FileStorePathFactory pathFactory;
    private final Map<Long, BulkFormatMapping> bulkFormatMappings;
    private int[][] projection;
    @Nullable
    private List<Predicate> filters;

    public AppendOnlyFileStoreRead(SchemaManager schemaManager, long schemaId, RowType rowType, FileFormat fileFormat, FileStorePathFactory pathFactory) {
        this.schemaManager = schemaManager;
        this.schemaId = schemaId;
        this.rowType = rowType;
        this.fileFormat = fileFormat;
        this.pathFactory = pathFactory;
        this.bulkFormatMappings = new HashMap<Long, BulkFormatMapping>();
        this.projection = Projection.range(0, rowType.getFieldCount()).toNestedIndexes();
    }

    public FileStoreRead<RowData> withProjection(int[][] projectedFields) {
        this.projection = projectedFields;
        return this;
    }

    @Override
    public FileStoreRead<RowData> withFilter(Predicate predicate) {
        this.filters = PredicateBuilder.splitAnd(predicate);
        return this;
    }

    @Override
    public RecordReader<RowData> createReader(DataSplit split) throws IOException {
        DataFilePathFactory dataFilePathFactory = this.pathFactory.createDataFilePathFactory(split.partition(), split.bucket());
        ArrayList suppliers = new ArrayList();
        for (DataFileMeta file : split.files()) {
            BulkFormatMapping bulkFormatMapping = this.bulkFormatMappings.computeIfAbsent(file.schemaId(), key -> {
                TableSchema tableSchema = this.schemaManager.schema(this.schemaId);
                TableSchema dataSchema = this.schemaManager.schema((long)key);
                int[][] dataProjection = SchemaEvolutionUtil.createDataProjection(tableSchema.fields(), dataSchema.fields(), this.projection);
                RowType rowType = dataSchema.logicalRowType();
                int[] indexMapping = SchemaEvolutionUtil.createIndexMapping(Projection.of(this.projection).toTopLevelIndexes(), tableSchema.fields(), Projection.of(dataProjection).toTopLevelIndexes(), dataSchema.fields());
                List<Predicate> dataFilters = this.schemaId == key ? this.filters : SchemaEvolutionUtil.createDataFilters(tableSchema.fields(), dataSchema.fields(), this.filters);
                return new BulkFormatMapping(indexMapping, this.fileFormat.createReaderFactory(rowType, dataProjection, dataFilters));
            });
            suppliers.add(() -> new RowDataFileRecordReader(dataFilePathFactory.toPath(file.fileName()), bulkFormatMapping.getReaderFactory(), bulkFormatMapping.getIndexMapping()));
        }
        return ConcatRecordReader.create(suppliers);
    }
}

