/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.table.catalog.CatalogDatabase;
import org.apache.flink.util.Preconditions;

public class CatalogDatabaseImpl
implements CatalogDatabase {
    private final Map<String, String> properties;
    private final String comment;

    public CatalogDatabaseImpl(Map<String, String> properties, @Nullable String comment) {
        this.properties = Preconditions.checkNotNull(properties, "properties cannot be null");
        this.comment = comment;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public CatalogDatabase copy() {
        return this.copy(this.getProperties());
    }

    @Override
    public CatalogDatabase copy(Map<String, String> properties) {
        return new CatalogDatabaseImpl(new HashMap<String, String>(properties), this.comment);
    }

    @Override
    public Optional<String> getDescription() {
        return Optional.ofNullable(this.comment);
    }

    @Override
    public Optional<String> getDetailedDescription() {
        return Optional.ofNullable(this.comment);
    }
}

