/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import org.apache.flink.annotation.Internal;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.LatencyMarker;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.watermarkstatus.WatermarkStatus;
import org.apache.flink.util.OutputTag;

@Internal
public final class TimestampedCollector<T>
implements Output<T> {
    private final Output<StreamRecord<T>> output;
    private final StreamRecord<T> reuse;

    public TimestampedCollector(Output<StreamRecord<T>> output) {
        this.output = output;
        this.reuse = new StreamRecord<Object>(null);
    }

    @Override
    public void collect(T record) {
        this.output.collect(this.reuse.replace(record));
    }

    public void setTimestamp(StreamRecord<?> timestampBase) {
        if (timestampBase.hasTimestamp()) {
            this.reuse.setTimestamp(timestampBase.getTimestamp());
        } else {
            this.reuse.eraseTimestamp();
        }
    }

    public void setAbsoluteTimestamp(long timestamp) {
        this.reuse.setTimestamp(timestamp);
    }

    public void eraseTimestamp() {
        this.reuse.eraseTimestamp();
    }

    @Override
    public void close() {
        this.output.close();
    }

    @Override
    public void emitWatermark(Watermark mark) {
        this.output.emitWatermark(mark);
    }

    @Override
    public void emitWatermarkStatus(WatermarkStatus watermarkStatus) {
        this.output.emitWatermarkStatus(watermarkStatus);
    }

    @Override
    public <X> void collect(OutputTag<X> outputTag, StreamRecord<X> record) {
        this.output.collect(outputTag, record);
    }

    @Override
    public void emitLatencyMarker(LatencyMarker latencyMarker) {
        this.output.emitLatencyMarker(latencyMarker);
    }
}

