/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.util.Objects;
import org.apache.flink.runtime.deployment.ResultPartitionDeploymentDescriptor;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.shuffle.ShuffleDescriptor;
import org.apache.flink.util.Preconditions;

public final class TaskExecutorPartitionInfo {
    private final IntermediateDataSetID intermediateDataSetId;
    private final ShuffleDescriptor shuffleDescriptor;
    private final int numberOfPartitions;

    public TaskExecutorPartitionInfo(ShuffleDescriptor shuffleDescriptor, IntermediateDataSetID intermediateDataSetId, int numberOfPartitions) {
        this.intermediateDataSetId = Preconditions.checkNotNull(intermediateDataSetId);
        this.shuffleDescriptor = Preconditions.checkNotNull(shuffleDescriptor);
        Preconditions.checkArgument(numberOfPartitions > 0);
        this.numberOfPartitions = numberOfPartitions;
    }

    public IntermediateDataSetID getIntermediateDataSetId() {
        return this.intermediateDataSetId;
    }

    public ResultPartitionID getResultPartitionId() {
        return this.shuffleDescriptor.getResultPartitionID();
    }

    public int getNumberOfPartitions() {
        return this.numberOfPartitions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskExecutorPartitionInfo that = (TaskExecutorPartitionInfo)o;
        return Objects.equals(this.intermediateDataSetId, that.intermediateDataSetId);
    }

    public int hashCode() {
        return Objects.hash(this.intermediateDataSetId);
    }

    public static TaskExecutorPartitionInfo from(ResultPartitionDeploymentDescriptor resultPartitionDeploymentDescriptor) {
        return new TaskExecutorPartitionInfo(resultPartitionDeploymentDescriptor.getShuffleDescriptor(), resultPartitionDeploymentDescriptor.getResultId(), resultPartitionDeploymentDescriptor.getTotalNumberOfPartitions());
    }

    public ShuffleDescriptor getShuffleDescriptor() {
        return this.shuffleDescriptor;
    }
}

