/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.table;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.file.src.FileSourceSplit;
import org.apache.flink.connector.file.src.reader.BulkFormat;
import org.apache.flink.connector.file.src.util.RecordMapperWrapperRecordIterator;
import org.apache.flink.connector.file.table.EnrichedRowData;
import org.apache.flink.connector.file.table.FileSystemTableSource;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.utils.PartitionPathUtils;

class FileInfoExtractorBulkFormat
implements BulkFormat<RowData, FileSourceSplit> {
    private final BulkFormat<RowData, FileSourceSplit> wrapped;
    private final TypeInformation<RowData> producedType;
    private final List<FileSystemTableSource.FileInfoAccessor> metadataColumnsFunctions;
    private final List<Map.Entry<String, DataType>> partitionColumnTypes;
    private final int[] extendedRowIndexMapping;
    private final String defaultPartName;

    public FileInfoExtractorBulkFormat(BulkFormat<RowData, FileSourceSplit> wrapped, DataType producedDataType, TypeInformation<RowData> producedTypeInformation, Map<String, FileSystemTableSource.FileInfoAccessor> metadataColumns, List<String> partitionColumns, String defaultPartName) {
        this.wrapped = wrapped;
        this.producedType = producedTypeInformation;
        this.defaultPartName = defaultPartName;
        List<DataTypes.Field> producedRowField = DataType.getFields(producedDataType);
        List<String> producedRowFieldNames = producedRowField.stream().map(DataTypes.AbstractField::getName).collect(Collectors.toList());
        List<String> mutableRowFieldNames = producedRowFieldNames.stream().filter(key -> !metadataColumns.containsKey(key) && !partitionColumns.contains(key)).collect(Collectors.toList());
        ArrayList<String> metadataFieldNames = new ArrayList<String>(metadataColumns.keySet());
        List<String> fixedRowFieldNames = Stream.concat(metadataFieldNames.stream(), partitionColumns.stream()).collect(Collectors.toList());
        this.partitionColumnTypes = partitionColumns.stream().map(fieldName -> new AbstractMap.SimpleImmutableEntry<String, DataType>((String)fieldName, ((DataTypes.Field)producedRowField.get(producedRowFieldNames.indexOf(fieldName))).getDataType())).collect(Collectors.toList());
        this.extendedRowIndexMapping = EnrichedRowData.computeIndexMapping(producedRowFieldNames, mutableRowFieldNames, fixedRowFieldNames);
        this.metadataColumnsFunctions = metadataFieldNames.stream().map(metadataColumns::get).collect(Collectors.toList());
    }

    @Override
    public BulkFormat.Reader<RowData> createReader(Configuration config, FileSourceSplit split) throws IOException {
        return this.wrapReader(this.wrapped.createReader(config, split), split);
    }

    @Override
    public BulkFormat.Reader<RowData> restoreReader(Configuration config, FileSourceSplit split) throws IOException {
        return this.wrapReader(this.wrapped.restoreReader(config, split), split);
    }

    @Override
    public boolean isSplittable() {
        return this.wrapped.isSplittable();
    }

    @Override
    public TypeInformation<RowData> getProducedType() {
        return this.producedType;
    }

    private BulkFormat.Reader<RowData> wrapReader(BulkFormat.Reader<RowData> superReader, FileSourceSplit split) {
        int fileInfoRowIndex;
        GenericRowData fileInfoRowData = new GenericRowData(this.metadataColumnsFunctions.size() + this.partitionColumnTypes.size());
        for (fileInfoRowIndex = 0; fileInfoRowIndex < this.metadataColumnsFunctions.size(); ++fileInfoRowIndex) {
            fileInfoRowData.setField(fileInfoRowIndex, this.metadataColumnsFunctions.get(fileInfoRowIndex).getValue(split));
        }
        if (!this.partitionColumnTypes.isEmpty()) {
            LinkedHashMap<String, String> partitionSpec = PartitionPathUtils.extractPartitionSpecFromPath(split.path());
            int partitionFieldIndex = 0;
            while (fileInfoRowIndex < fileInfoRowData.getArity()) {
                String fieldName = this.partitionColumnTypes.get(partitionFieldIndex).getKey();
                DataType fieldType = this.partitionColumnTypes.get(partitionFieldIndex).getValue();
                if (!partitionSpec.containsKey(fieldName)) {
                    throw new RuntimeException("Cannot find the partition value from path for partition: " + fieldName);
                }
                String valueStr = partitionSpec.get(fieldName);
                valueStr = valueStr.equals(this.defaultPartName) ? null : valueStr;
                fileInfoRowData.setField(fileInfoRowIndex, PartitionPathUtils.convertStringToInternalValue(valueStr, fieldType));
                ++fileInfoRowIndex;
                ++partitionFieldIndex;
            }
        }
        EnrichedRowData producedRowData = new EnrichedRowData(fileInfoRowData, this.extendedRowIndexMapping);
        return RecordMapperWrapperRecordIterator.wrapReader(superReader, physicalRowData -> {
            producedRowData.replaceMutableRow((RowData)physicalRowData);
            return producedRowData;
        });
    }
}

