/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.logical;

import java.util.Collections;
import java.util.List;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.expressions.TableSymbol;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.LogicalTypeVisitor;

@PublicEvolving
public final class SymbolType<T extends TableSymbol>
extends LogicalType {
    private static final long serialVersionUID = 2L;
    private static final String FORMAT = "SYMBOL";

    @Deprecated
    public SymbolType(boolean isNullable, Class<T> clazz) {
        this(isNullable);
    }

    @Deprecated
    public SymbolType(Class<T> clazz) {
        this();
    }

    public SymbolType(boolean isNullable) {
        super(isNullable, LogicalTypeRoot.SYMBOL);
    }

    public SymbolType() {
        this(true);
    }

    @Override
    public LogicalType copy(boolean isNullable) {
        return new SymbolType<T>(isNullable);
    }

    @Override
    public String asSummaryString() {
        return this.withNullability(FORMAT, new Object[0]);
    }

    @Override
    public String asSerializableString() {
        throw new TableException("A symbol type has no serializable string representation.");
    }

    @Override
    public boolean supportsInputConversion(Class<?> clazz) {
        return Enum.class.isAssignableFrom(clazz);
    }

    @Override
    public boolean supportsOutputConversion(Class<?> clazz) {
        return Enum.class.isAssignableFrom(clazz);
    }

    @Override
    public Class<?> getDefaultConversion() {
        return Enum.class;
    }

    @Override
    public List<LogicalType> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public <R> R accept(LogicalTypeVisitor<R> visitor) {
        return visitor.visit(this);
    }
}

