/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.codegen;

import java.time.Duration;
import java.util.Objects;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.shaded.guava30.com.google.common.cache.Cache;
import org.apache.flink.shaded.guava30.com.google.common.cache.CacheBuilder;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.Preconditions;
import org.codehaus.janino.SimpleCompiler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CompileUtils {
    private static final Logger CODE_LOG = LoggerFactory.getLogger(CompileUtils.class);
    static final Cache<ClassKey, Class<?>> COMPILED_CLASS_CACHE = CacheBuilder.newBuilder().expireAfterAccess(Duration.ofMinutes(5L)).maximumSize(300L).softValues().build();

    public static <T> Class<T> compile(ClassLoader cl, String name, String code) {
        try {
            ClassKey classKey = new ClassKey(cl.hashCode(), code);
            return COMPILED_CLASS_CACHE.get(classKey, () -> CompileUtils.doCompile(cl, name, code));
        }
        catch (Exception e) {
            throw new FlinkRuntimeException(e.getMessage(), e);
        }
    }

    private static <T> Class<T> doCompile(ClassLoader cl, String name, String code) {
        Preconditions.checkNotNull(cl, "Classloader must not be null.");
        CODE_LOG.debug("Compiling: {} \n\n Code:\n{}", (Object)name, (Object)code);
        SimpleCompiler compiler = new SimpleCompiler();
        compiler.setParentClassLoader(cl);
        try {
            compiler.cook(code);
        }
        catch (Throwable t) {
            System.out.println(CompileUtils.addLineNumber(code));
            throw new InvalidProgramException("Table program cannot be compiled. This is a bug. Please file an issue.", t);
        }
        try {
            return compiler.getClassLoader().loadClass(name);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Can not load class " + name, e);
        }
    }

    private static String addLineNumber(String code) {
        String[] lines = code.split("\n");
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < lines.length; ++i) {
            builder.append("/* ").append(i + 1).append(" */").append(lines[i]).append("\n");
        }
        return builder.toString();
    }

    private static class ClassKey {
        private final int classLoaderId;
        private final String code;

        private ClassKey(int classLoaderId, String code) {
            this.classLoaderId = classLoaderId;
            this.code = code;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClassKey classKey = (ClassKey)o;
            return this.classLoaderId == classKey.classLoaderId && this.code.equals(classKey.code);
        }

        public int hashCode() {
            return Objects.hash(this.classLoaderId, this.code);
        }
    }
}

