/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.shipping;

import org.apache.flink.api.common.distributions.DataDistribution;
import org.apache.flink.api.common.functions.Partitioner;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.runtime.io.network.api.writer.ChannelSelector;
import org.apache.flink.runtime.operators.shipping.ShipStrategyType;
import org.apache.flink.runtime.plugable.SerializationDelegate;
import org.apache.flink.util.MathUtils;

public class OutputEmitter<T>
implements ChannelSelector<SerializationDelegate<T>> {
    private final ShipStrategyType strategy;
    private int nextChannelToSendTo;
    private int numberOfChannels;
    private final TypeComparator<T> comparator;
    private Object[][] partitionBoundaries;
    private DataDistribution distribution;
    private final Partitioner<Object> partitioner;
    private TypeComparator[] flatComparators;
    private Object[] keys;
    private Object[] extractedKeys;

    public OutputEmitter(ShipStrategyType strategy, int indexInSubtaskGroup) {
        this(strategy, indexInSubtaskGroup, null, null, null);
    }

    public OutputEmitter(ShipStrategyType strategy, TypeComparator<T> comparator) {
        this(strategy, 0, comparator, null, null);
    }

    public OutputEmitter(ShipStrategyType strategy, int indexInSubtaskGroup, TypeComparator<T> comparator, Partitioner<?> partitioner, DataDistribution distribution) {
        if (strategy == null) {
            throw new NullPointerException();
        }
        this.strategy = strategy;
        this.nextChannelToSendTo = indexInSubtaskGroup;
        this.comparator = comparator;
        this.partitioner = partitioner;
        this.distribution = distribution;
        switch (strategy) {
            case PARTITION_CUSTOM: {
                this.extractedKeys = new Object[1];
            }
            case FORWARD: 
            case PARTITION_HASH: 
            case PARTITION_RANDOM: 
            case PARTITION_FORCED_REBALANCE: {
                break;
            }
            case PARTITION_RANGE: {
                if (comparator == null) break;
                this.flatComparators = comparator.getFlatComparators();
                this.keys = new Object[this.flatComparators.length];
                break;
            }
            case BROADCAST: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid shipping strategy for OutputEmitter: " + strategy.name());
            }
        }
        if (strategy == ShipStrategyType.PARTITION_CUSTOM && partitioner == null) {
            throw new NullPointerException("Partitioner must not be null when the ship strategy is set to custom partitioning.");
        }
    }

    @Override
    public void setup(int numberOfChannels) {
        this.numberOfChannels = numberOfChannels;
    }

    @Override
    public final int selectChannel(SerializationDelegate<T> record) {
        switch (this.strategy) {
            case FORWARD: {
                return this.forward();
            }
            case PARTITION_RANDOM: 
            case PARTITION_FORCED_REBALANCE: {
                return this.robin(this.numberOfChannels);
            }
            case PARTITION_HASH: {
                return this.hashPartitionDefault(record.getInstance(), this.numberOfChannels);
            }
            case PARTITION_CUSTOM: {
                return this.customPartition(record.getInstance(), this.numberOfChannels);
            }
            case PARTITION_RANGE: {
                return this.rangePartition(record.getInstance(), this.numberOfChannels);
            }
        }
        throw new UnsupportedOperationException("Unsupported distribution strategy: " + this.strategy.name());
    }

    @Override
    public boolean isBroadcast() {
        return this.strategy == ShipStrategyType.BROADCAST;
    }

    private int forward() {
        return 0;
    }

    private int robin(int numberOfChannels) {
        int nextChannel = this.nextChannelToSendTo;
        if (nextChannel >= numberOfChannels) {
            nextChannel = nextChannel == numberOfChannels ? 0 : (nextChannel %= numberOfChannels);
        }
        this.nextChannelToSendTo = nextChannel + 1;
        return nextChannel;
    }

    private int hashPartitionDefault(T record, int numberOfChannels) {
        int hash = this.comparator.hash(record);
        return MathUtils.murmurHash(hash) % numberOfChannels;
    }

    private int rangePartition(T record, int numberOfChannels) {
        if (this.partitionBoundaries == null) {
            this.partitionBoundaries = new Object[numberOfChannels - 1][];
            for (int i = 0; i < numberOfChannels - 1; ++i) {
                this.partitionBoundaries[i] = this.distribution.getBucketBoundary(i, numberOfChannels);
            }
        }
        if (numberOfChannels == this.partitionBoundaries.length + 1) {
            Object[][] boundaries = this.partitionBoundaries;
            int low = 0;
            int high = this.partitionBoundaries.length - 1;
            while (low <= high) {
                int mid = low + high >>> 1;
                int result = this.compareRecordAndBoundary(record, boundaries[mid]);
                if (result > 0) {
                    low = mid + 1;
                    continue;
                }
                if (result < 0) {
                    high = mid - 1;
                    continue;
                }
                return mid;
            }
            return low;
        }
        throw new IllegalStateException("The number of channels to partition among is inconsistent with the partitioners state.");
    }

    private int customPartition(T record, int numberOfChannels) {
        if (this.extractedKeys == null) {
            this.extractedKeys = new Object[1];
        }
        try {
            if (this.comparator.extractKeys(record, this.extractedKeys, 0) == 1) {
                Object key = this.extractedKeys[0];
                return this.partitioner.partition(key, numberOfChannels);
            }
            throw new RuntimeException("Inconsistency in the key comparator - comparator extracted more than one field.");
        }
        catch (Throwable t) {
            throw new RuntimeException("Error while calling custom partitioner.", t);
        }
    }

    private final int compareRecordAndBoundary(T record, Object[] boundary) {
        this.comparator.extractKeys(record, this.keys, 0);
        if (this.flatComparators.length != this.keys.length || this.flatComparators.length > boundary.length) {
            throw new RuntimeException("Can not compare keys with boundary due to mismatched length.");
        }
        for (int i = 0; i < this.flatComparators.length; ++i) {
            int result = this.flatComparators[i].compare(this.keys[i], boundary[i]);
            if (result == 0) continue;
            return result;
        }
        return 0;
    }
}

