/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.table.sink;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.table.store.file.io.CompactIncrement;
import org.apache.flink.table.store.file.io.DataFileMetaSerializer;
import org.apache.flink.table.store.file.io.NewFilesIncrement;
import org.apache.flink.table.store.file.utils.SerializationUtils;
import org.apache.flink.table.store.table.sink.FileCommittable;

public class FileCommittableSerializer
implements SimpleVersionedSerializer<FileCommittable> {
    private static final int CURRENT_VERSION = 2;
    private final DataFileMetaSerializer dataFileSerializer = new DataFileMetaSerializer();

    public int getVersion() {
        return 2;
    }

    public byte[] serialize(FileCommittable obj) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DataOutputViewStreamWrapper view = new DataOutputViewStreamWrapper((OutputStream)out);
        this.serialize(obj, (DataOutputView)view);
        return out.toByteArray();
    }

    public void serializeList(List<FileCommittable> list, DataOutputView view) throws IOException {
        view.writeInt(list.size());
        for (FileCommittable fileCommittable : list) {
            this.serialize(fileCommittable, view);
        }
    }

    private void serialize(FileCommittable obj, DataOutputView view) throws IOException {
        SerializationUtils.serializeBinaryRow(obj.partition(), view);
        view.writeInt(obj.bucket());
        this.dataFileSerializer.serializeList(obj.newFilesIncrement().newFiles(), view);
        this.dataFileSerializer.serializeList(obj.newFilesIncrement().changelogFiles(), view);
        this.dataFileSerializer.serializeList(obj.compactIncrement().compactBefore(), view);
        this.dataFileSerializer.serializeList(obj.compactIncrement().compactAfter(), view);
        this.dataFileSerializer.serializeList(obj.compactIncrement().changelogFiles(), view);
    }

    public FileCommittable deserialize(int version, byte[] serialized) throws IOException {
        this.checkVersion(version);
        DataInputDeserializer view = new DataInputDeserializer(serialized);
        return this.deserialize((DataInputView)view);
    }

    public List<FileCommittable> deserializeList(int version, DataInputView view) throws IOException {
        this.checkVersion(version);
        int length = view.readInt();
        ArrayList<FileCommittable> list = new ArrayList<FileCommittable>(length);
        for (int i = 0; i < length; ++i) {
            list.add(this.deserialize(view));
        }
        return list;
    }

    private void checkVersion(int version) {
        if (version != 2) {
            throw new UnsupportedOperationException("Expecting FileCommittable version to be 2, but found " + version + ".\nFileCommittable is not a compatible data structure. Please restart the job afresh (do not recover from savepoint).");
        }
    }

    private FileCommittable deserialize(DataInputView view) throws IOException {
        return new FileCommittable(SerializationUtils.deserializeBinaryRow(view), view.readInt(), new NewFilesIncrement(this.dataFileSerializer.deserializeList(view), this.dataFileSerializer.deserializeList(view)), new CompactIncrement(this.dataFileSerializer.deserializeList(view), this.dataFileSerializer.deserializeList(view), this.dataFileSerializer.deserializeList(view)));
    }
}

