/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.manifest;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.serialization.BulkWriter;
import org.apache.flink.connector.file.src.FileSourceSplit;
import org.apache.flink.connector.file.src.reader.BulkFormat;
import org.apache.flink.core.fs.Path;
import org.apache.flink.shaded.guava30.com.google.common.collect.Iterables;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.store.file.io.RollingFileWriter;
import org.apache.flink.table.store.file.io.SingleFileWriter;
import org.apache.flink.table.store.file.manifest.ManifestEntry;
import org.apache.flink.table.store.file.manifest.ManifestEntrySerializer;
import org.apache.flink.table.store.file.manifest.ManifestFileMeta;
import org.apache.flink.table.store.file.schema.SchemaManager;
import org.apache.flink.table.store.file.stats.FieldStatsArraySerializer;
import org.apache.flink.table.store.file.utils.FileStorePathFactory;
import org.apache.flink.table.store.file.utils.FileUtils;
import org.apache.flink.table.store.file.utils.VersionedObjectSerializer;
import org.apache.flink.table.store.format.FieldStatsCollector;
import org.apache.flink.table.store.format.FileFormat;
import org.apache.flink.table.types.logical.RowType;

public class ManifestFile {
    private final SchemaManager schemaManager;
    private final long schemaId;
    private final RowType partitionType;
    private final ManifestEntrySerializer serializer;
    private final BulkFormat<RowData, FileSourceSplit> readerFactory;
    private final BulkWriter.Factory<RowData> writerFactory;
    private final FileStorePathFactory pathFactory;
    private final long suggestedFileSize;

    private ManifestFile(SchemaManager schemaManager, long schemaId, RowType partitionType, ManifestEntrySerializer serializer, BulkFormat<RowData, FileSourceSplit> readerFactory, BulkWriter.Factory<RowData> writerFactory, FileStorePathFactory pathFactory, long suggestedFileSize) {
        this.schemaManager = schemaManager;
        this.schemaId = schemaId;
        this.partitionType = partitionType;
        this.serializer = serializer;
        this.readerFactory = readerFactory;
        this.writerFactory = writerFactory;
        this.pathFactory = pathFactory;
        this.suggestedFileSize = suggestedFileSize;
    }

    @VisibleForTesting
    public long suggestedFileSize() {
        return this.suggestedFileSize;
    }

    public List<ManifestEntry> read(String fileName) {
        try {
            return FileUtils.readListFromFile(this.pathFactory.toManifestFilePath(fileName), this.serializer, this.readerFactory);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read manifest file " + fileName, e);
        }
    }

    public Iterable<ManifestEntry> readManifestFiles(List<String> manifestFiles) {
        final LinkedList<String> files = new LinkedList<String>(manifestFiles);
        return Iterables.concat(() -> new Iterator<Iterable<ManifestEntry>>(){

            @Override
            public boolean hasNext() {
                return files.size() > 0;
            }

            @Override
            public Iterable<ManifestEntry> next() {
                return ManifestFile.this.read((String)files.poll());
            }
        });
    }

    public List<ManifestFileMeta> write(List<ManifestEntry> entries) {
        RollingFileWriter writer = new RollingFileWriter(() -> new ManifestEntryWriter(this.writerFactory, this.pathFactory.newManifestFile()), this.suggestedFileSize);
        try {
            writer.write(entries);
            writer.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return writer.result();
    }

    public void delete(String fileName) {
        FileUtils.deleteOrWarn(this.pathFactory.toManifestFilePath(fileName));
    }

    public static class Factory {
        private final SchemaManager schemaManager;
        private final long schemaId;
        private final RowType partitionType;
        private final FileFormat fileFormat;
        private final FileStorePathFactory pathFactory;
        private final long suggestedFileSize;

        public Factory(SchemaManager schemaManager, long schemaId, RowType partitionType, FileFormat fileFormat, FileStorePathFactory pathFactory, long suggestedFileSize) {
            this.schemaManager = schemaManager;
            this.schemaId = schemaId;
            this.partitionType = partitionType;
            this.fileFormat = fileFormat;
            this.pathFactory = pathFactory;
            this.suggestedFileSize = suggestedFileSize;
        }

        public ManifestFile create() {
            RowType entryType = VersionedObjectSerializer.versionType(ManifestEntry.schema());
            return new ManifestFile(this.schemaManager, this.schemaId, this.partitionType, new ManifestEntrySerializer(), this.fileFormat.createReaderFactory(entryType), this.fileFormat.createWriterFactory(entryType), this.pathFactory, this.suggestedFileSize);
        }
    }

    private class ManifestEntryWriter
    extends SingleFileWriter<ManifestEntry, ManifestFileMeta> {
        private final FieldStatsCollector partitionStatsCollector;
        private final FieldStatsArraySerializer partitionStatsSerializer;
        private long numAddedFiles;
        private long numDeletedFiles;

        ManifestEntryWriter(BulkWriter.Factory<RowData> factory, Path path) {
            super(factory, path, ManifestFile.this.serializer::toRow);
            this.numAddedFiles = 0L;
            this.numDeletedFiles = 0L;
            this.partitionStatsCollector = new FieldStatsCollector(ManifestFile.this.partitionType);
            this.partitionStatsSerializer = new FieldStatsArraySerializer(ManifestFile.this.partitionType);
        }

        @Override
        public void write(ManifestEntry entry) throws IOException {
            super.write(entry);
            switch (entry.kind()) {
                case ADD: {
                    ++this.numAddedFiles;
                    break;
                }
                case DELETE: {
                    ++this.numDeletedFiles;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown entry kind: " + (Object)((Object)entry.kind()));
                }
            }
            this.partitionStatsCollector.collect((RowData)entry.partition());
        }

        @Override
        public ManifestFileMeta result() throws IOException {
            return new ManifestFileMeta(this.path.getName(), this.path.getFileSystem().getFileStatus(this.path).getLen(), this.numAddedFiles, this.numDeletedFiles, this.partitionStatsSerializer.toBinary(this.partitionStatsCollector.extract()), ManifestFile.this.schemaId);
        }
    }
}

