/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.operation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinTask;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.store.file.Snapshot;
import org.apache.flink.table.store.file.manifest.ManifestEntry;
import org.apache.flink.table.store.file.manifest.ManifestFile;
import org.apache.flink.table.store.file.manifest.ManifestFileMeta;
import org.apache.flink.table.store.file.manifest.ManifestList;
import org.apache.flink.table.store.file.operation.FileStoreScan;
import org.apache.flink.table.store.file.predicate.BucketSelector;
import org.apache.flink.table.store.file.predicate.Predicate;
import org.apache.flink.table.store.file.predicate.PredicateBuilder;
import org.apache.flink.table.store.file.stats.FieldStatsArraySerializer;
import org.apache.flink.table.store.file.utils.FileStorePathFactory;
import org.apache.flink.table.store.file.utils.FileUtils;
import org.apache.flink.table.store.file.utils.SnapshotManager;
import org.apache.flink.table.store.utils.RowDataToObjectArrayConverter;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;

public abstract class AbstractFileStoreScan
implements FileStoreScan {
    private final FieldStatsArraySerializer partitionStatsConverter;
    private final RowDataToObjectArrayConverter partitionConverter;
    protected final RowType bucketKeyType;
    private final SnapshotManager snapshotManager;
    private final ManifestFile.Factory manifestFileFactory;
    private final ManifestList manifestList;
    private final int numOfBuckets;
    private final boolean checkNumOfBuckets;
    private Predicate partitionFilter;
    private BucketSelector bucketSelector;
    private Long specifiedSnapshotId = null;
    private Integer specifiedBucket = null;
    private List<ManifestFileMeta> specifiedManifests = null;
    private boolean isIncremental = false;

    public AbstractFileStoreScan(RowType partitionType, RowType bucketKeyType, SnapshotManager snapshotManager, ManifestFile.Factory manifestFileFactory, ManifestList.Factory manifestListFactory, int numOfBuckets, boolean checkNumOfBuckets) {
        this.partitionStatsConverter = new FieldStatsArraySerializer(partitionType);
        this.partitionConverter = new RowDataToObjectArrayConverter(partitionType);
        Preconditions.checkArgument(bucketKeyType.getFieldCount() > 0, "The bucket keys should not be empty.");
        this.bucketKeyType = bucketKeyType;
        this.snapshotManager = snapshotManager;
        this.manifestFileFactory = manifestFileFactory;
        this.manifestList = manifestListFactory.create();
        this.numOfBuckets = numOfBuckets;
        this.checkNumOfBuckets = checkNumOfBuckets;
    }

    @Override
    public FileStoreScan withPartitionFilter(Predicate predicate) {
        this.partitionFilter = predicate;
        return this;
    }

    protected FileStoreScan withBucketKeyFilter(Predicate predicate) {
        this.bucketSelector = BucketSelector.create(predicate, this.bucketKeyType).orElse(null);
        return this;
    }

    @Override
    public FileStoreScan withPartitionFilter(List<BinaryRowData> partitions) {
        PredicateBuilder builder = new PredicateBuilder(this.partitionConverter.rowType());
        Function<BinaryRowData, Predicate> partitionToPredicate = p -> {
            ArrayList<Predicate> fieldPredicates = new ArrayList<Predicate>();
            Object[] partitionObjects = this.partitionConverter.convert((RowData)p);
            for (int i = 0; i < this.partitionConverter.getArity(); ++i) {
                Object partition = partitionObjects[i];
                fieldPredicates.add(builder.equal(i, partition));
            }
            return PredicateBuilder.and(fieldPredicates);
        };
        List<Predicate> predicates = partitions.stream().filter(p -> p.getArity() > 0).map(partitionToPredicate).collect(Collectors.toList());
        if (predicates.isEmpty()) {
            return this;
        }
        return this.withPartitionFilter(PredicateBuilder.or(predicates));
    }

    @Override
    public FileStoreScan withBucket(int bucket) {
        this.specifiedBucket = bucket;
        return this;
    }

    @Override
    public FileStoreScan withSnapshot(long snapshotId) {
        this.specifiedSnapshotId = snapshotId;
        if (this.specifiedManifests != null) {
            throw new IllegalStateException("Cannot set both snapshot id and manifests.");
        }
        return this;
    }

    @Override
    public FileStoreScan withManifestList(List<ManifestFileMeta> manifests) {
        this.specifiedManifests = manifests;
        if (this.specifiedSnapshotId != null) {
            throw new IllegalStateException("Cannot set both snapshot id and manifests.");
        }
        return this;
    }

    @Override
    public FileStoreScan withIncremental(boolean isIncremental) {
        this.isIncremental = isIncremental;
        return this;
    }

    @Override
    public FileStoreScan.Plan plan() {
        List entries;
        List<ManifestFileMeta> manifests = this.specifiedManifests;
        Long snapshotId = this.specifiedSnapshotId;
        if (manifests == null) {
            if (snapshotId == null) {
                snapshotId = this.snapshotManager.latestSnapshotId();
            }
            if (snapshotId == null) {
                manifests = Collections.emptyList();
            } else {
                Snapshot snapshot = this.snapshotManager.snapshot(snapshotId);
                manifests = this.isIncremental ? this.readIncremental(snapshotId) : snapshot.readAllManifests(this.manifestList);
            }
        }
        final Long readSnapshot = snapshotId;
        List<ManifestFileMeta> readManifests = manifests;
        try {
            entries = (List)((ForkJoinTask)FileUtils.COMMON_IO_FORK_JOIN_POOL.submit(() -> readManifests.parallelStream().filter(this::filterManifestFileMeta).flatMap(m -> this.readManifestFileMeta((ManifestFileMeta)m).stream()).filter(this::filterManifestEntry).collect(Collectors.toList()))).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException("Failed to read ManifestEntry list concurrently", e);
        }
        final ArrayList<ManifestEntry> files = new ArrayList<ManifestEntry>();
        for (ManifestEntry file : ManifestEntry.mergeManifestEntries(entries)) {
            if (this.checkNumOfBuckets && file.totalBuckets() != this.numOfBuckets) {
                String partInfo = this.partitionConverter.getArity() > 0 ? "partition " + FileStorePathFactory.getPartitionComputer(this.partitionConverter.rowType(), FileStorePathFactory.PARTITION_DEFAULT_NAME.defaultValue()).generatePartValues(file.partition()) : "table";
                throw new TableException(String.format("Try to write %s with a new bucket num %d, but the previous bucket num is %d. Please switch to batch mode, and perform INSERT OVERWRITE to rescale current data layout first.", partInfo, this.numOfBuckets, file.totalBuckets()));
            }
            if (!this.filterByBucket(file) || !this.filterByBucketSelector(file)) continue;
            files.add(file);
        }
        return new FileStoreScan.Plan(){

            @Override
            @Nullable
            public Long snapshotId() {
                return readSnapshot;
            }

            @Override
            public List<ManifestEntry> files() {
                return files;
            }
        };
    }

    private boolean filterManifestFileMeta(ManifestFileMeta manifest) {
        return this.partitionFilter == null || this.partitionFilter.test(manifest.numAddedFiles() + manifest.numDeletedFiles(), manifest.partitionStats().fields(this.partitionStatsConverter));
    }

    private boolean filterManifestEntry(ManifestEntry entry) {
        return this.filterByPartition(entry) && this.filterByStats(entry);
    }

    private boolean filterByPartition(ManifestEntry entry) {
        return this.partitionFilter == null || this.partitionFilter.test(this.partitionConverter.convert(entry.partition()));
    }

    private boolean filterByBucket(ManifestEntry entry) {
        return this.specifiedBucket == null || entry.bucket() == this.specifiedBucket.intValue();
    }

    private boolean filterByBucketSelector(ManifestEntry entry) {
        return this.bucketSelector == null || this.bucketSelector.select(entry.bucket(), entry.totalBuckets());
    }

    protected abstract boolean filterByStats(ManifestEntry var1);

    private List<ManifestEntry> readManifestFileMeta(ManifestFileMeta manifest) {
        return this.manifestFileFactory.create().read(manifest.fileName());
    }

    private List<ManifestFileMeta> readIncremental(Long snapshotId) {
        Snapshot snapshot = this.snapshotManager.snapshot(snapshotId);
        if (snapshot.commitKind() == Snapshot.CommitKind.APPEND) {
            return this.manifestList.read(snapshot.deltaManifestList());
        }
        throw new IllegalStateException(String.format("Incremental scan does not accept %s snapshot", new Object[]{snapshot.commitKind()}));
    }
}

