/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.expressions;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ExpressionVisitor;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public final class UnresolvedReferenceExpression
implements Expression {
    private final String name;

    UnresolvedReferenceExpression(String name) {
        this.name = Preconditions.checkNotNull(name);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String asSummaryString() {
        return this.name;
    }

    @Override
    public List<Expression> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public <R> R accept(ExpressionVisitor<R> visitor) {
        return visitor.visit(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnresolvedReferenceExpression that = (UnresolvedReferenceExpression)o;
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public String toString() {
        return this.asSummaryString();
    }
}

