/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators.sort;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;

final class KeyAndValueSerializer<IN>
extends TypeSerializer<Tuple2<byte[], StreamRecord<IN>>> {
    private static final int TIMESTAMP_LENGTH = 8;
    private final TypeSerializer<IN> valueSerializer;
    private final int serializedKeyLength;

    KeyAndValueSerializer(TypeSerializer<IN> valueSerializer, int serializedKeyLength) {
        this.valueSerializer = valueSerializer;
        this.serializedKeyLength = serializedKeyLength;
    }

    @Override
    public boolean isImmutableType() {
        return false;
    }

    @Override
    public TypeSerializer<Tuple2<byte[], StreamRecord<IN>>> duplicate() {
        return new KeyAndValueSerializer<IN>(this.valueSerializer.duplicate(), this.serializedKeyLength);
    }

    @Override
    public Tuple2<byte[], StreamRecord<IN>> copy(Tuple2<byte[], StreamRecord<IN>> from) {
        StreamRecord fromRecord = (StreamRecord)from.f1;
        return Tuple2.of(Arrays.copyOf((byte[])from.f0, ((byte[])from.f0).length), fromRecord.copy(this.valueSerializer.copy(fromRecord.getValue())));
    }

    @Override
    public Tuple2<byte[], StreamRecord<IN>> createInstance() {
        return Tuple2.of(new byte[0], new StreamRecord<IN>(this.valueSerializer.createInstance()));
    }

    @Override
    public Tuple2<byte[], StreamRecord<IN>> copy(Tuple2<byte[], StreamRecord<IN>> from, Tuple2<byte[], StreamRecord<IN>> reuse) {
        StreamRecord fromRecord = (StreamRecord)from.f1;
        StreamRecord reuseRecord = (StreamRecord)reuse.f1;
        IN valueCopy = this.valueSerializer.copy(fromRecord.getValue(), reuseRecord.getValue());
        fromRecord.copyTo(valueCopy, reuseRecord);
        reuse.f0 = Arrays.copyOf((byte[])from.f0, ((byte[])from.f0).length);
        reuse.f1 = reuseRecord;
        return reuse;
    }

    @Override
    public int getLength() {
        if (this.valueSerializer.getLength() < 0 || this.serializedKeyLength < 0) {
            return -1;
        }
        return this.valueSerializer.getLength() + this.serializedKeyLength + 8;
    }

    @Override
    public void serialize(Tuple2<byte[], StreamRecord<IN>> record, DataOutputView target) throws IOException {
        if (this.serializedKeyLength < 0) {
            target.writeInt(((byte[])record.f0).length);
        }
        target.write((byte[])record.f0);
        StreamRecord toSerialize = (StreamRecord)record.f1;
        target.writeLong(toSerialize.getTimestamp());
        this.valueSerializer.serialize(toSerialize.getValue(), target);
    }

    @Override
    public Tuple2<byte[], StreamRecord<IN>> deserialize(DataInputView source) throws IOException {
        int length = this.getKeyLength(source);
        byte[] bytes = new byte[length];
        source.read(bytes);
        long timestamp = source.readLong();
        IN value = this.valueSerializer.deserialize(source);
        return Tuple2.of(bytes, new StreamRecord<IN>(value, timestamp));
    }

    @Override
    public Tuple2<byte[], StreamRecord<IN>> deserialize(Tuple2<byte[], StreamRecord<IN>> reuse, DataInputView source) throws IOException {
        int length = this.getKeyLength(source);
        byte[] bytes = new byte[length];
        source.read(bytes);
        long timestamp = source.readLong();
        IN value = this.valueSerializer.deserialize(source);
        StreamRecord reuseRecord = (StreamRecord)reuse.f1;
        reuseRecord.replace(value, timestamp);
        reuse.f0 = bytes;
        reuse.f1 = reuseRecord;
        return reuse;
    }

    private int getKeyLength(DataInputView source) throws IOException {
        int length = this.serializedKeyLength < 0 ? source.readInt() : this.serializedKeyLength;
        return length;
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        int length;
        if (this.serializedKeyLength < 0) {
            length = source.readInt();
            target.writeInt(length);
        } else {
            length = this.serializedKeyLength;
        }
        for (int i = 0; i < length; ++i) {
            target.writeByte(source.readByte());
        }
        target.writeLong(source.readLong());
        this.valueSerializer.copy(source, target);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyAndValueSerializer that = (KeyAndValueSerializer)o;
        return Objects.equals(this.valueSerializer, that.valueSerializer);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.valueSerializer);
    }

    @Override
    public TypeSerializerSnapshot<Tuple2<byte[], StreamRecord<IN>>> snapshotConfiguration() {
        throw new UnsupportedOperationException("The KeyAndValueSerializer should not be used for persisting into State!");
    }
}

