/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.spark;

import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.store.spark.SparkInternalRow;
import org.apache.flink.table.store.utils.RowDataUtils;
import org.apache.flink.table.store.utils.TypeUtils;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.SpecializedGetters;
import org.apache.spark.sql.catalyst.expressions.SpecializedGettersReader;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;

public class SparkArrayData
extends org.apache.spark.sql.catalyst.util.ArrayData {
    private final LogicalType elementType;
    private ArrayData array;

    public SparkArrayData(LogicalType elementType) {
        this.elementType = elementType;
    }

    public SparkArrayData replace(ArrayData array) {
        this.array = array;
        return this;
    }

    public int numElements() {
        return this.array.size();
    }

    public org.apache.spark.sql.catalyst.util.ArrayData copy() {
        return new SparkArrayData(this.elementType).replace(RowDataUtils.copyArray(this.array, this.elementType));
    }

    public Object[] array() {
        Object[] objects = new Object[this.numElements()];
        for (int i = 0; i < objects.length; ++i) {
            objects[i] = SparkInternalRow.fromFlink(RowDataUtils.get(this.array, i, this.elementType), this.elementType);
        }
        return objects;
    }

    public void setNullAt(int i) {
        throw new UnsupportedOperationException();
    }

    public void update(int i, Object value) {
        throw new UnsupportedOperationException();
    }

    public boolean isNullAt(int ordinal) {
        return this.array.isNullAt(ordinal);
    }

    public boolean getBoolean(int ordinal) {
        return this.array.getBoolean(ordinal);
    }

    public byte getByte(int ordinal) {
        return this.array.getByte(ordinal);
    }

    public short getShort(int ordinal) {
        return this.array.getShort(ordinal);
    }

    public int getInt(int ordinal) {
        return this.array.getInt(ordinal);
    }

    public long getLong(int ordinal) {
        if (this.elementType instanceof BigIntType) {
            return this.array.getLong(ordinal);
        }
        return this.getTimestampMicros(ordinal);
    }

    private long getTimestampMicros(int ordinal) {
        return SparkInternalRow.fromFlink(this.array.getTimestamp(ordinal, TypeUtils.timestampPrecision(this.elementType)));
    }

    public float getFloat(int ordinal) {
        return this.array.getFloat(ordinal);
    }

    public double getDouble(int ordinal) {
        return this.array.getDouble(ordinal);
    }

    public Decimal getDecimal(int ordinal, int precision, int scale) {
        return SparkInternalRow.fromFlink(this.array.getDecimal(ordinal, precision, scale));
    }

    public UTF8String getUTF8String(int ordinal) {
        return SparkInternalRow.fromFlink(this.array.getString(ordinal));
    }

    public byte[] getBinary(int ordinal) {
        return this.array.getBinary(ordinal);
    }

    public CalendarInterval getInterval(int ordinal) {
        throw new UnsupportedOperationException();
    }

    public InternalRow getStruct(int ordinal, int numFields) {
        return SparkInternalRow.fromFlink(this.array.getRow(ordinal, numFields), (RowType)this.elementType);
    }

    public org.apache.spark.sql.catalyst.util.ArrayData getArray(int ordinal) {
        return SparkInternalRow.fromFlink(this.array.getArray(ordinal), (ArrayType)this.elementType);
    }

    public MapData getMap(int ordinal) {
        return SparkInternalRow.fromFlink(this.array.getMap(ordinal), this.elementType);
    }

    public Object get(int ordinal, DataType dataType) {
        return SpecializedGettersReader.read((SpecializedGetters)this, (int)ordinal, (DataType)dataType, (boolean)true, (boolean)true);
    }
}

