/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.messages.webmonitor;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.executiongraph.AccessExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.AccessExecutionVertex;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonParser;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import org.apache.flink.util.Preconditions;

@JsonSerialize(using=JobDetailsSerializer.class)
@JsonDeserialize(using=JobDetailsDeserializer.class)
public class JobDetails
implements Serializable {
    private static final long serialVersionUID = -3391462110304948766L;
    private static final String FIELD_NAME_JOB_ID = "jid";
    private static final String FIELD_NAME_JOB_NAME = "name";
    private static final String FIELD_NAME_START_TIME = "start-time";
    private static final String FIELD_NAME_END_TIME = "end-time";
    private static final String FIELD_NAME_DURATION = "duration";
    private static final String FIELD_NAME_STATUS = "state";
    private static final String FIELD_NAME_LAST_MODIFICATION = "last-modification";
    private static final String FIELD_NAME_TOTAL_NUMBER_TASKS = "total";
    private final JobID jobId;
    private final String jobName;
    private final long startTime;
    private final long endTime;
    private final long duration;
    private final JobStatus status;
    private final long lastUpdateTime;
    private final int[] tasksPerState;
    private final int numTasks;

    public JobDetails(JobID jobId, String jobName, long startTime, long endTime, long duration, JobStatus status, long lastUpdateTime, int[] tasksPerState, int numTasks) {
        this.jobId = Preconditions.checkNotNull(jobId);
        this.jobName = Preconditions.checkNotNull(jobName);
        this.startTime = startTime;
        this.endTime = endTime;
        this.duration = duration;
        this.status = Preconditions.checkNotNull(status);
        this.lastUpdateTime = lastUpdateTime;
        Preconditions.checkArgument(tasksPerState.length == ExecutionState.values().length, "tasksPerState argument must be of size %s.", ExecutionState.values().length);
        this.tasksPerState = Preconditions.checkNotNull(tasksPerState);
        this.numTasks = numTasks;
    }

    public static JobDetails createDetailsForJob(AccessExecutionGraph job) {
        JobStatus status = job.getState();
        long started = job.getStatusTimestamp(JobStatus.INITIALIZING);
        long finished = status.isGloballyTerminalState() ? job.getStatusTimestamp(status) : -1L;
        long duration = (finished >= 0L ? finished : System.currentTimeMillis()) - started;
        int[] countsPerStatus = new int[ExecutionState.values().length];
        long lastChanged = 0L;
        int numTotalTasks = 0;
        for (AccessExecutionJobVertex accessExecutionJobVertex : job.getVerticesTopologically()) {
            AccessExecutionVertex[] taskVertices = accessExecutionJobVertex.getTaskVertices();
            numTotalTasks += taskVertices.length;
            for (AccessExecutionVertex taskVertex : taskVertices) {
                ExecutionState state = taskVertex.getExecutionState();
                int n = state.ordinal();
                countsPerStatus[n] = countsPerStatus[n] + 1;
                lastChanged = Math.max(lastChanged, taskVertex.getStateTimestamp(state));
            }
        }
        lastChanged = Math.max(lastChanged, finished);
        return new JobDetails(job.getJobID(), job.getJobName(), started, finished, duration, status, lastChanged, countsPerStatus, numTotalTasks);
    }

    public JobID getJobId() {
        return this.jobId;
    }

    public String getJobName() {
        return this.jobName;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public long getDuration() {
        return this.duration;
    }

    public JobStatus getStatus() {
        return this.status;
    }

    public long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public int getNumTasks() {
        return this.numTasks;
    }

    public int[] getTasksPerState() {
        return this.tasksPerState;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o != null && o.getClass() == JobDetails.class) {
            JobDetails that = (JobDetails)o;
            return this.endTime == that.endTime && this.lastUpdateTime == that.lastUpdateTime && this.numTasks == that.numTasks && this.startTime == that.startTime && this.status == that.status && this.jobId.equals(that.jobId) && this.jobName.equals(that.jobName) && Arrays.equals(this.tasksPerState, that.tasksPerState);
        }
        return false;
    }

    public int hashCode() {
        int result = this.jobId.hashCode();
        result = 31 * result + this.jobName.hashCode();
        result = 31 * result + (int)(this.startTime ^ this.startTime >>> 32);
        result = 31 * result + (int)(this.endTime ^ this.endTime >>> 32);
        result = 31 * result + this.status.hashCode();
        result = 31 * result + (int)(this.lastUpdateTime ^ this.lastUpdateTime >>> 32);
        result = 31 * result + Arrays.hashCode(this.tasksPerState);
        result = 31 * result + this.numTasks;
        return result;
    }

    public String toString() {
        return "JobDetails {jobId=" + this.jobId + ", jobName='" + this.jobName + '\'' + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", status=" + (Object)((Object)this.status) + ", lastUpdateTime=" + this.lastUpdateTime + ", numVerticesPerExecutionState=" + Arrays.toString(this.tasksPerState) + ", numTasks=" + this.numTasks + '}';
    }

    public static final class JobDetailsDeserializer
    extends StdDeserializer<JobDetails> {
        private static final long serialVersionUID = 6089784742093294800L;

        public JobDetailsDeserializer() {
            super(JobDetails.class);
        }

        @Override
        public JobDetails deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            JsonNode rootNode = (JsonNode)jsonParser.readValueAsTree();
            JobID jobId = JobID.fromHexString(rootNode.get(JobDetails.FIELD_NAME_JOB_ID).textValue());
            String jobName = rootNode.get(JobDetails.FIELD_NAME_JOB_NAME).textValue();
            long startTime = rootNode.get(JobDetails.FIELD_NAME_START_TIME).longValue();
            long endTime = rootNode.get(JobDetails.FIELD_NAME_END_TIME).longValue();
            long duration = rootNode.get(JobDetails.FIELD_NAME_DURATION).longValue();
            JobStatus jobStatus = JobStatus.valueOf(rootNode.get(JobDetails.FIELD_NAME_STATUS).textValue());
            long lastUpdateTime = rootNode.get(JobDetails.FIELD_NAME_LAST_MODIFICATION).longValue();
            JsonNode tasksNode = rootNode.get("tasks");
            int numTasks = tasksNode.get(JobDetails.FIELD_NAME_TOTAL_NUMBER_TASKS).intValue();
            int[] numVerticesPerExecutionState = new int[ExecutionState.values().length];
            for (ExecutionState executionState : ExecutionState.values()) {
                JsonNode jsonNode = tasksNode.get(executionState.name().toLowerCase());
                numVerticesPerExecutionState[executionState.ordinal()] = jsonNode == null ? 0 : jsonNode.intValue();
            }
            return new JobDetails(jobId, jobName, startTime, endTime, duration, jobStatus, lastUpdateTime, numVerticesPerExecutionState, numTasks);
        }
    }

    public static final class JobDetailsSerializer
    extends StdSerializer<JobDetails> {
        private static final long serialVersionUID = 7915913423515194428L;

        public JobDetailsSerializer() {
            super(JobDetails.class);
        }

        @Override
        public void serialize(JobDetails jobDetails, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField(JobDetails.FIELD_NAME_JOB_ID, jobDetails.getJobId().toString());
            jsonGenerator.writeStringField(JobDetails.FIELD_NAME_JOB_NAME, jobDetails.getJobName());
            jsonGenerator.writeStringField(JobDetails.FIELD_NAME_STATUS, jobDetails.getStatus().name());
            jsonGenerator.writeNumberField(JobDetails.FIELD_NAME_START_TIME, jobDetails.getStartTime());
            jsonGenerator.writeNumberField(JobDetails.FIELD_NAME_END_TIME, jobDetails.getEndTime());
            jsonGenerator.writeNumberField(JobDetails.FIELD_NAME_DURATION, jobDetails.getDuration());
            jsonGenerator.writeNumberField(JobDetails.FIELD_NAME_LAST_MODIFICATION, jobDetails.getLastUpdateTime());
            jsonGenerator.writeObjectFieldStart("tasks");
            jsonGenerator.writeNumberField(JobDetails.FIELD_NAME_TOTAL_NUMBER_TASKS, jobDetails.getNumTasks());
            int[] perState = jobDetails.getTasksPerState();
            for (ExecutionState executionState : ExecutionState.values()) {
                jsonGenerator.writeNumberField(executionState.name().toLowerCase(), perState[executionState.ordinal()]);
            }
            jsonGenerator.writeEndObject();
            jsonGenerator.writeEndObject();
        }
    }
}

