/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph.metrics;

import org.apache.flink.api.common.JobStatus;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.runtime.executiongraph.JobStatusProvider;
import org.apache.flink.util.Preconditions;

public class UpTimeGauge
implements Gauge<Long> {
    public static final String METRIC_NAME = "uptime";
    private static final long NO_LONGER_RUNNING = -1L;
    private final JobStatusProvider jobStatusProvider;

    public UpTimeGauge(JobStatusProvider jobStatusProvider) {
        this.jobStatusProvider = Preconditions.checkNotNull(jobStatusProvider);
    }

    public Long getValue() {
        JobStatus status = this.jobStatusProvider.getState();
        if (status == JobStatus.RUNNING) {
            long runningTimestamp = this.jobStatusProvider.getStatusTimestamp(JobStatus.RUNNING);
            return Math.max(System.currentTimeMillis() - runningTimestamp, 0L);
        }
        if (status.isTerminalState()) {
            return -1L;
        }
        return 0L;
    }
}

