/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations.ddl;

import java.util.Collections;
import java.util.LinkedHashMap;
import org.apache.flink.table.catalog.CatalogFunction;
import org.apache.flink.table.catalog.CatalogFunctionImpl;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.catalog.FunctionLanguage;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.OperationUtils;
import org.apache.flink.table.operations.ddl.CreateOperation;

public class CreateTempSystemFunctionOperation
implements CreateOperation {
    private final String functionName;
    private final boolean ignoreIfExists;
    private final CatalogFunction catalogFunction;

    public CreateTempSystemFunctionOperation(String functionName, String functionClass, boolean ignoreIfExists, FunctionLanguage functionLanguage) {
        this.functionName = functionName;
        this.ignoreIfExists = ignoreIfExists;
        this.catalogFunction = new CatalogFunctionImpl(functionClass, functionLanguage);
    }

    public CreateTempSystemFunctionOperation(String functionName, boolean ignoreIfExists, FunctionDefinition functionDefinition) {
        this.functionName = functionName;
        this.ignoreIfExists = ignoreIfExists;
        this.catalogFunction = new FunctionCatalog.InlineCatalogFunction(functionDefinition);
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public boolean isIgnoreIfExists() {
        return this.ignoreIfExists;
    }

    public CatalogFunction getCatalogFunction() {
        return this.catalogFunction;
    }

    @Override
    public String asSummaryString() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("functionName", this.functionName);
        params.put("catalogFunction", this.getCatalogFunction());
        params.put("ignoreIfExists", this.ignoreIfExists);
        params.put("functionLanguage", (Object)this.getCatalogFunction().getFunctionLanguage());
        return OperationUtils.formatWithChildren("CREATE TEMPORARY SYSTEM FUNCTION", params, Collections.emptyList(), Operation::asSummaryString);
    }
}

