/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.messages;

import java.io.Serializable;
import java.lang.management.ThreadInfo;
import java.util.Optional;
import javax.annotation.Nullable;

public class ThreadInfoSample
implements Serializable {
    private final Thread.State threadState;
    private final StackTraceElement[] stackTrace;

    private ThreadInfoSample(Thread.State threadState, StackTraceElement[] stackTrace) {
        this.threadState = threadState;
        this.stackTrace = stackTrace;
    }

    public static Optional<ThreadInfoSample> from(@Nullable ThreadInfo threadInfo) {
        if (threadInfo != null) {
            return Optional.of(new ThreadInfoSample(threadInfo.getThreadState(), threadInfo.getStackTrace()));
        }
        return Optional.empty();
    }

    public Thread.State getThreadState() {
        return this.threadState;
    }

    public StackTraceElement[] getStackTrace() {
        return (StackTraceElement[])this.stackTrace.clone();
    }
}

