/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.util.Collection;
import java.util.Comparator;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.jobmanager.scheduler.Locality;
import org.apache.flink.runtime.jobmaster.slotpool.LocationPreferenceSlotSelectionStrategy;
import org.apache.flink.runtime.jobmaster.slotpool.SlotSelectionStrategy;

class EvenlySpreadOutLocationPreferenceSlotSelectionStrategy
extends LocationPreferenceSlotSelectionStrategy {
    EvenlySpreadOutLocationPreferenceSlotSelectionStrategy() {
    }

    @Override
    @Nonnull
    protected Optional<SlotSelectionStrategy.SlotInfoAndLocality> selectWithoutLocationPreference(@Nonnull Collection<SlotSelectionStrategy.SlotInfoAndResources> availableSlots, @Nonnull ResourceProfile resourceProfile) {
        return availableSlots.stream().filter(slotInfoAndResources -> slotInfoAndResources.getRemainingResources().isMatching(resourceProfile)).min(Comparator.comparing(SlotSelectionStrategy.SlotInfoAndResources::getTaskExecutorUtilization)).map(slotInfoAndResources -> SlotSelectionStrategy.SlotInfoAndLocality.of(slotInfoAndResources.getSlotInfo(), Locality.UNCONSTRAINED));
    }

    @Override
    protected double calculateCandidateScore(int localWeigh, int hostLocalWeigh, double taskExecutorUtilization) {
        return (double)(localWeigh * 20 + hostLocalWeigh * 2) - taskExecutorUtilization;
    }
}

