/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.utils;

import java.sql.Date;
import java.time.DateTimeException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.TimeZone;
import org.apache.flink.table.data.TimestampData;

public class DateTimeUtils {
    public static final int EPOCH_JULIAN = 2440588;
    private static final long MILLIS_PER_SECOND = 1000L;
    private static final long MILLIS_PER_MINUTE = 60000L;
    private static final long MILLIS_PER_HOUR = 3600000L;
    public static final long MILLIS_PER_DAY = 86400000L;
    public static final TimeZone LOCAL_TZ = TimeZone.getDefault();
    private static final DateTimeFormatter DEFAULT_TIMESTAMP_FORMATTER = new DateTimeFormatterBuilder().appendPattern("yyyy-[MM][M]-[dd][d]").optionalStart().appendPattern(" [HH][H]:[mm][m]:[ss][s]").appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).optionalEnd().toFormatter();

    public static Date toSQLDate(int v) {
        long t = (long)v * 86400000L;
        return new Date(t - (long)LOCAL_TZ.getOffset(t));
    }

    public static int toInternal(Date date) {
        long ts = date.getTime() + (long)LOCAL_TZ.getOffset(date.getTime());
        return (int)(ts / 86400000L);
    }

    public static Integer parseDate(String s) {
        int d;
        int m;
        int y;
        int hyphen1;
        int ws1 = s.indexOf(" ");
        if (ws1 > 0) {
            s = s.substring(0, ws1);
        }
        if ((hyphen1 = s.indexOf(45)) < 0) {
            if (!DateTimeUtils.isInteger(s.trim())) {
                return null;
            }
            y = Integer.parseInt(s.trim());
            m = 1;
            d = 1;
        } else {
            if (!DateTimeUtils.isInteger(s.substring(0, hyphen1).trim())) {
                return null;
            }
            y = Integer.parseInt(s.substring(0, hyphen1).trim());
            int hyphen2 = s.indexOf(45, hyphen1 + 1);
            if (hyphen2 < 0) {
                if (!DateTimeUtils.isInteger(s.substring(hyphen1 + 1).trim())) {
                    return null;
                }
                m = Integer.parseInt(s.substring(hyphen1 + 1).trim());
                d = 1;
            } else {
                if (!DateTimeUtils.isInteger(s.substring(hyphen1 + 1, hyphen2).trim())) {
                    return null;
                }
                m = Integer.parseInt(s.substring(hyphen1 + 1, hyphen2).trim());
                if (!DateTimeUtils.isInteger(s.substring(hyphen2 + 1).trim())) {
                    return null;
                }
                d = Integer.parseInt(s.substring(hyphen2 + 1).trim());
            }
        }
        if (!DateTimeUtils.isIllegalDate(y, m, d)) {
            return null;
        }
        return DateTimeUtils.ymdToUnixDate(y, m, d);
    }

    public static Integer parseTime(String v) {
        int milli;
        int second;
        int minute;
        int hour;
        int timezoneMinute;
        int timezoneHour;
        boolean start = false;
        int colon1 = v.indexOf(58, 0);
        int operator = -1;
        int end = v.length();
        int timezone = v.indexOf(45, 0);
        if (timezone < 0) {
            timezone = v.indexOf(43, 0);
            operator = 1;
        }
        if (timezone < 0) {
            timezoneHour = 0;
            timezoneMinute = 0;
        } else {
            end = timezone;
            int colon3 = v.indexOf(58, timezone);
            if (colon3 < 0) {
                if (!DateTimeUtils.isInteger(v.substring(timezone + 1).trim())) {
                    return null;
                }
                timezoneHour = Integer.parseInt(v.substring(timezone + 1).trim());
                timezoneMinute = 0;
            } else {
                if (!DateTimeUtils.isInteger(v.substring(timezone + 1, colon3).trim())) {
                    return null;
                }
                timezoneHour = Integer.parseInt(v.substring(timezone + 1, colon3).trim());
                if (!DateTimeUtils.isInteger(v.substring(colon3 + 1).trim())) {
                    return null;
                }
                timezoneMinute = Integer.parseInt(v.substring(colon3 + 1).trim());
            }
        }
        if (colon1 < 0) {
            if (!DateTimeUtils.isInteger(v.substring(0, end).trim())) {
                return null;
            }
            hour = Integer.parseInt(v.substring(0, end).trim());
            minute = 0;
            second = 0;
            milli = 0;
        } else {
            if (!DateTimeUtils.isInteger(v.substring(0, colon1).trim())) {
                return null;
            }
            hour = Integer.parseInt(v.substring(0, colon1).trim());
            int colon2 = v.indexOf(58, colon1 + 1);
            if (colon2 < 0) {
                if (!DateTimeUtils.isInteger(v.substring(colon1 + 1, end).trim())) {
                    return null;
                }
                minute = Integer.parseInt(v.substring(colon1 + 1, end).trim());
                second = 0;
                milli = 0;
            } else {
                if (!DateTimeUtils.isInteger(v.substring(colon1 + 1, colon2).trim())) {
                    return null;
                }
                minute = Integer.parseInt(v.substring(colon1 + 1, colon2).trim());
                int dot = v.indexOf(46, colon2);
                if (dot < 0) {
                    if (!DateTimeUtils.isInteger(v.substring(colon2 + 1, end).trim())) {
                        return null;
                    }
                    second = Integer.parseInt(v.substring(colon2 + 1, end).trim());
                    milli = 0;
                } else {
                    if (!DateTimeUtils.isInteger(v.substring(colon2 + 1, dot).trim())) {
                        return null;
                    }
                    second = Integer.parseInt(v.substring(colon2 + 1, dot).trim());
                    milli = DateTimeUtils.parseFraction(v.substring(dot + 1, end).trim());
                }
            }
        }
        return (hour += operator * timezoneHour) * 3600000 + (minute += operator * timezoneMinute) * 60000 + second * 1000 + milli;
    }

    private static boolean isInteger(String s) {
        boolean isInt = s.length() > 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) >= '0' && s.charAt(i) <= '9') continue;
            isInt = false;
            break;
        }
        return isInt;
    }

    private static boolean isIllegalDate(int y, int m, int d) {
        int[] monthOf31Days = new int[]{1, 3, 5, 7, 8, 10, 12};
        if (y < 0 || y > 9999 || m < 1 || m > 12 || d < 1 || d > 31) {
            return false;
        }
        if (!(m != 2 || d <= 28 || DateTimeUtils.isLeapYear(y) && d == 29)) {
            return false;
        }
        if (d == 31) {
            for (int i : monthOf31Days) {
                if (i != m) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private static int parseFraction(String v) {
        int multiplier = 100;
        int r = 0;
        for (int i = 0; i < v.length(); ++i) {
            char c = v.charAt(i);
            int x = c < '0' || c > '9' ? 0 : c - 48;
            r += multiplier * x;
            if (multiplier < 10) {
                if (i + 1 >= v.length() || v.charAt(i + 1) < '5') break;
                ++r;
                break;
            }
            multiplier /= 10;
        }
        return r;
    }

    private static boolean isLeapYear(int s) {
        return s % 400 == 0 || s % 4 == 0 && s % 100 != 0;
    }

    private static int ymdToUnixDate(int year, int month, int day) {
        int julian = DateTimeUtils.ymdToJulian(year, month, day);
        return julian - 2440588;
    }

    private static int ymdToJulian(int year, int month, int day) {
        int a = (14 - month) / 12;
        int y = year + 4800 - a;
        int m = month + 12 * a - 3;
        return day + (153 * m + 2) / 5 + 365 * y + y / 4 - y / 100 + y / 400 - 32045;
    }

    public static TimestampData parseTimestampData(String dateStr, int precision) throws DateTimeException {
        return TimestampData.fromLocalDateTime((LocalDateTime)DateTimeUtils.fromTemporalAccessor(DEFAULT_TIMESTAMP_FORMATTER.parse(dateStr), precision));
    }

    private static LocalDateTime fromTemporalAccessor(TemporalAccessor accessor, int precision) {
        int nanoOfSecond;
        int year = accessor.isSupported(ChronoField.YEAR) ? accessor.get(ChronoField.YEAR) : 1970;
        int month = accessor.isSupported(ChronoField.MONTH_OF_YEAR) ? accessor.get(ChronoField.MONTH_OF_YEAR) : 1;
        int day = accessor.isSupported(ChronoField.DAY_OF_MONTH) ? accessor.get(ChronoField.DAY_OF_MONTH) : 1;
        int hour = accessor.isSupported(ChronoField.HOUR_OF_DAY) ? accessor.get(ChronoField.HOUR_OF_DAY) : 0;
        int minute = accessor.isSupported(ChronoField.MINUTE_OF_HOUR) ? accessor.get(ChronoField.MINUTE_OF_HOUR) : 0;
        int second = accessor.isSupported(ChronoField.SECOND_OF_MINUTE) ? accessor.get(ChronoField.SECOND_OF_MINUTE) : 0;
        int n = nanoOfSecond = accessor.isSupported(ChronoField.NANO_OF_SECOND) ? accessor.get(ChronoField.NANO_OF_SECOND) : 0;
        if (precision == 0) {
            nanoOfSecond = 0;
        } else if (precision != 9) {
            nanoOfSecond = (int)DateTimeUtils.floor(nanoOfSecond, DateTimeUtils.powerX(10L, 9 - precision));
        }
        return LocalDateTime.of(year, month, day, hour, minute, second, nanoOfSecond);
    }

    private static long floor(long a, long b) {
        long r = a % b;
        if (r < 0L) {
            return a - r - b;
        }
        return a - r;
    }

    private static long powerX(long a, long b) {
        long x = 1L;
        while (b > 0L) {
            x *= a;
            --b;
        }
        return x;
    }
}

