/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.kafka.common.message;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.message.VoteRequestData;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.protocol.MessageUtil;

public class VoteRequestDataJsonConverter {
    public static VoteRequestData read(JsonNode _node, short _version) {
        VoteRequestData _object = new VoteRequestData();
        JsonNode _clusterIdNode = _node.get("clusterId");
        if (_clusterIdNode == null) {
            throw new RuntimeException("VoteRequestData: unable to locate field 'clusterId', which is mandatory in version " + _version);
        }
        if (_clusterIdNode.isNull()) {
            _object.clusterId = null;
        } else {
            if (!_clusterIdNode.isTextual()) {
                throw new RuntimeException("VoteRequestData expected a string type, but got " + _node.getNodeType());
            }
            _object.clusterId = _clusterIdNode.asText();
        }
        JsonNode _topicsNode = _node.get("topics");
        if (_topicsNode == null) {
            throw new RuntimeException("VoteRequestData: unable to locate field 'topics', which is mandatory in version " + _version);
        }
        if (!_topicsNode.isArray()) {
            throw new RuntimeException("VoteRequestData expected a JSON array, but got " + _node.getNodeType());
        }
        ArrayList<VoteRequestData.TopicData> _collection = new ArrayList<VoteRequestData.TopicData>(_topicsNode.size());
        _object.topics = _collection;
        for (JsonNode _element : _topicsNode) {
            _collection.add(TopicDataJsonConverter.read(_element, _version));
        }
        return _object;
    }

    public static JsonNode write(VoteRequestData _object, short _version, boolean _serializeRecords) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        if (_object.clusterId == null) {
            _node.set("clusterId", (JsonNode)NullNode.instance);
        } else {
            _node.set("clusterId", (JsonNode)new TextNode(_object.clusterId));
        }
        ArrayNode _topicsArray = new ArrayNode(JsonNodeFactory.instance);
        for (VoteRequestData.TopicData _element : _object.topics) {
            _topicsArray.add(TopicDataJsonConverter.write(_element, _version, _serializeRecords));
        }
        _node.set("topics", (JsonNode)_topicsArray);
        return _node;
    }

    public static JsonNode write(VoteRequestData _object, short _version) {
        return VoteRequestDataJsonConverter.write(_object, _version, true);
    }

    public static class TopicDataJsonConverter {
        public static VoteRequestData.TopicData read(JsonNode _node, short _version) {
            VoteRequestData.TopicData _object = new VoteRequestData.TopicData();
            JsonNode _topicNameNode = _node.get("topicName");
            if (_topicNameNode == null) {
                throw new RuntimeException("TopicData: unable to locate field 'topicName', which is mandatory in version " + _version);
            }
            if (!_topicNameNode.isTextual()) {
                throw new RuntimeException("TopicData expected a string type, but got " + _node.getNodeType());
            }
            _object.topicName = _topicNameNode.asText();
            JsonNode _partitionsNode = _node.get("partitions");
            if (_partitionsNode == null) {
                throw new RuntimeException("TopicData: unable to locate field 'partitions', which is mandatory in version " + _version);
            }
            if (!_partitionsNode.isArray()) {
                throw new RuntimeException("TopicData expected a JSON array, but got " + _node.getNodeType());
            }
            ArrayList<VoteRequestData.PartitionData> _collection = new ArrayList<VoteRequestData.PartitionData>(_partitionsNode.size());
            _object.partitions = _collection;
            for (JsonNode _element : _partitionsNode) {
                _collection.add(PartitionDataJsonConverter.read(_element, _version));
            }
            return _object;
        }

        public static JsonNode write(VoteRequestData.TopicData _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("topicName", (JsonNode)new TextNode(_object.topicName));
            ArrayNode _partitionsArray = new ArrayNode(JsonNodeFactory.instance);
            for (VoteRequestData.PartitionData _element : _object.partitions) {
                _partitionsArray.add(PartitionDataJsonConverter.write(_element, _version, _serializeRecords));
            }
            _node.set("partitions", (JsonNode)_partitionsArray);
            return _node;
        }

        public static JsonNode write(VoteRequestData.TopicData _object, short _version) {
            return TopicDataJsonConverter.write(_object, _version, true);
        }
    }

    public static class PartitionDataJsonConverter {
        public static VoteRequestData.PartitionData read(JsonNode _node, short _version) {
            VoteRequestData.PartitionData _object = new VoteRequestData.PartitionData();
            JsonNode _partitionIndexNode = _node.get("partitionIndex");
            if (_partitionIndexNode == null) {
                throw new RuntimeException("PartitionData: unable to locate field 'partitionIndex', which is mandatory in version " + _version);
            }
            _object.partitionIndex = MessageUtil.jsonNodeToInt(_partitionIndexNode, "PartitionData");
            JsonNode _candidateEpochNode = _node.get("candidateEpoch");
            if (_candidateEpochNode == null) {
                throw new RuntimeException("PartitionData: unable to locate field 'candidateEpoch', which is mandatory in version " + _version);
            }
            _object.candidateEpoch = MessageUtil.jsonNodeToInt(_candidateEpochNode, "PartitionData");
            JsonNode _candidateIdNode = _node.get("candidateId");
            if (_candidateIdNode == null) {
                throw new RuntimeException("PartitionData: unable to locate field 'candidateId', which is mandatory in version " + _version);
            }
            _object.candidateId = MessageUtil.jsonNodeToInt(_candidateIdNode, "PartitionData");
            JsonNode _lastOffsetEpochNode = _node.get("lastOffsetEpoch");
            if (_lastOffsetEpochNode == null) {
                throw new RuntimeException("PartitionData: unable to locate field 'lastOffsetEpoch', which is mandatory in version " + _version);
            }
            _object.lastOffsetEpoch = MessageUtil.jsonNodeToInt(_lastOffsetEpochNode, "PartitionData");
            JsonNode _lastOffsetNode = _node.get("lastOffset");
            if (_lastOffsetNode == null) {
                throw new RuntimeException("PartitionData: unable to locate field 'lastOffset', which is mandatory in version " + _version);
            }
            _object.lastOffset = MessageUtil.jsonNodeToLong(_lastOffsetNode, "PartitionData");
            return _object;
        }

        public static JsonNode write(VoteRequestData.PartitionData _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("partitionIndex", (JsonNode)new IntNode(_object.partitionIndex));
            _node.set("candidateEpoch", (JsonNode)new IntNode(_object.candidateEpoch));
            _node.set("candidateId", (JsonNode)new IntNode(_object.candidateId));
            _node.set("lastOffsetEpoch", (JsonNode)new IntNode(_object.lastOffsetEpoch));
            _node.set("lastOffset", (JsonNode)new LongNode(_object.lastOffset));
            return _node;
        }

        public static JsonNode write(VoteRequestData.PartitionData _object, short _version) {
            return PartitionDataJsonConverter.write(_object, _version, true);
        }
    }
}

