/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.agents.runtime.python.context;

import javax.annotation.concurrent.NotThreadSafe;
import org.apache.flink.agents.api.Event;
import org.apache.flink.agents.plan.AgentPlan;
import org.apache.flink.agents.runtime.context.RunnerContextImpl;
import org.apache.flink.agents.runtime.memory.CachedMemoryStore;
import org.apache.flink.agents.runtime.metrics.FlinkAgentsMetricGroupImpl;
import org.apache.flink.agents.runtime.python.event.PythonEvent;
import org.apache.flink.agents.runtime.python.utils.PythonActionExecutor;
import org.apache.flink.util.Preconditions;

@NotThreadSafe
public class PythonRunnerContextImpl
extends RunnerContextImpl {
    private final PythonActionExecutor pythonActionExecutor;

    public PythonRunnerContextImpl(CachedMemoryStore store, FlinkAgentsMetricGroupImpl agentMetricGroup, Runnable mailboxThreadChecker, AgentPlan agentPlan, PythonActionExecutor pythonActionExecutor) {
        super(store, agentMetricGroup, mailboxThreadChecker, agentPlan);
        this.pythonActionExecutor = pythonActionExecutor;
    }

    @Override
    public void sendEvent(Event event) {
        Preconditions.checkState((boolean)(event instanceof PythonEvent), (Object)"PythonRunnerContext only accept Python event.");
        super.sendEvent(event);
    }

    public void sendEvent(String type, byte[] event, String eventString) {
        this.sendEvent(new PythonEvent(event, type, eventString));
    }

    public PythonActionExecutor getPythonActionExecutor() {
        return this.pythonActionExecutor;
    }
}

