/*
 * Decompiled with CFR 0.152.
 */
package flex.tools.debugger.cli;

import java.util.AbstractList;
import java.util.ArrayList;

public class StringIntArray
extends AbstractList<Object> {
    Object[] m_ar;
    int m_size = 0;
    double m_growthRatio = 1.6;

    public StringIntArray(Object[] objectArray) {
        this.m_ar = objectArray;
        this.m_size = this.m_ar.length;
    }

    public StringIntArray() {
        this(10);
    }

    public StringIntArray(int n) {
        this.m_ar = new Object[n];
        this.m_size = 0;
    }

    @Override
    public Object get(int n) {
        return this.m_ar[n];
    }

    @Override
    public int size() {
        return this.m_size;
    }

    public Object[] getElement(int n) {
        return (Object[])this.get(n);
    }

    public String getString(int n) {
        return (String)this.getElement(n)[0];
    }

    public Integer getInteger(int n) {
        return (Integer)this.getElement(n)[1];
    }

    public int getInt(int n) {
        return this.getInteger(n);
    }

    public ArrayList<Integer> elementsStartingWith(String string) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < this.m_size; ++i) {
            if (!this.getString(i).startsWith(string)) continue;
            arrayList.add(new Integer(i));
        }
        return arrayList;
    }

    @Override
    public void add(int n, Object object) {
        this.ensureCapacity(1);
        int n2 = this.size();
        System.arraycopy(this.m_ar, n, this.m_ar, n + 1, n2 - n);
        this.m_ar[n] = object;
        ++this.m_size;
    }

    @Override
    public Object remove(int n) {
        int n2 = this.size();
        Object object = this.m_ar[n];
        System.arraycopy(this.m_ar, n + 1, this.m_ar, n, n2 - n + 1);
        --this.m_size;
        return object;
    }

    void ensureCapacity(int n) {
        int n2 = this.size();
        int n3 = n + n2;
        if (n3 > this.m_ar.length) {
            double d = (double)this.m_ar.length * this.m_growthRatio;
            if ((double)n3 > d) {
                d += (double)n3 + (double)n3 * this.m_growthRatio;
            }
            Object[] objectArray = new Object[(int)d + 1];
            System.arraycopy(this.m_ar, 0, objectArray, 0, this.m_ar.length);
            this.m_ar = objectArray;
        }
    }
}

