/*
 * Decompiled with CFR 0.152.
 */
package flash.tools.debugger.expression;

import flash.localization.LocalizationManager;
import flash.tools.debugger.DebuggerLocalizer;
import flash.tools.debugger.expression.DebuggerExpression;
import flash.tools.debugger.expression.DebuggerUtil;
import flash.tools.debugger.expression.IASTBuilder;
import flash.tools.debugger.expression.ValueExp;
import java.io.IOException;
import java.io.Reader;
import java.text.ParseException;
import java.util.ArrayList;
import org.apache.flex.compiler.problems.ICompilerProblem;
import org.apache.flex.compiler.tree.as.IASNode;

public class ASTBuilder
implements IASTBuilder {
    private static LocalizationManager s_localizationManager = new LocalizationManager();
    private boolean m_isIndirectionOperatorAllowed = true;

    public ASTBuilder(boolean bl) {
        this.m_isIndirectionOperatorAllowed = bl;
    }

    public boolean isIndirectionOperatorAllowed() {
        return this.m_isIndirectionOperatorAllowed;
    }

    @Override
    public ValueExp parse(Reader reader) throws IOException, ParseException {
        int n;
        DebuggerExpression debuggerExpression = new DebuggerExpression();
        StringBuilder stringBuilder = new StringBuilder();
        while ((n = reader.read()) != -1) {
            stringBuilder.append((char)n);
        }
        String string = stringBuilder.toString();
        string = string.replaceFirst("^#([0-9]+)", "\\$obj($1)");
        if (this.isIndirectionOperatorAllowed()) {
            if (string.endsWith(".")) {
                debuggerExpression.setLookupMembers(true);
                string = string.substring(0, string.length() - 1);
            } else if (string.startsWith("*")) {
                debuggerExpression.setLookupMembers(true);
                string = string.substring(1);
            }
        }
        string = "(" + string + ")";
        ArrayList<ICompilerProblem> arrayList = new ArrayList<ICompilerProblem>();
        IASNode iASNode = DebuggerUtil.parseExpression(string, arrayList);
        if (arrayList.size() > 0) {
            ICompilerProblem iCompilerProblem = (ICompilerProblem)arrayList.get(0);
            throw new ParseException(iCompilerProblem.toString(), iCompilerProblem.getColumn());
        }
        debuggerExpression.setProgramNode(iASNode);
        return debuggerExpression;
    }

    static LocalizationManager getLocalizationManager() {
        return s_localizationManager;
    }

    static {
        s_localizationManager.addLocalizer(new DebuggerLocalizer("flash.tools.debugger.expression.expression."));
    }
}

