/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.primitives.Longs;
import com.google.common.truth.AbstractArraySubject;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.ListSubject;
import java.util.Arrays;
import java.util.List;

public class PrimitiveLongArraySubject
extends AbstractArraySubject<PrimitiveLongArraySubject, long[]> {
    PrimitiveLongArraySubject(FailureStrategy failureStrategy, long[] o) {
        super(failureStrategy, o);
    }

    @Override
    protected String underlyingType() {
        return "long";
    }

    @Override
    protected List<Long> listRepresentation() {
        return Longs.asList((long[])((long[])this.getSubject()));
    }

    @Override
    public void isEqualTo(Object expected) {
        long[] actual = (long[])this.getSubject();
        if (actual == expected) {
            return;
        }
        try {
            long[] expectedArray = (long[])expected;
            if (!Arrays.equals(actual, expectedArray)) {
                this.fail("is equal to", (Object)Longs.asList((long[])expectedArray));
            }
        }
        catch (ClassCastException e) {
            this.failWithBadType(expected);
        }
    }

    @Override
    public void isNotEqualTo(Object expected) {
        long[] actual = (long[])this.getSubject();
        try {
            long[] expectedArray = (long[])expected;
            if (actual == expected || Arrays.equals(actual, expectedArray)) {
                this.failWithRawMessage("%s unexpectedly equal to %s.", this.getDisplaySubject(), Longs.asList((long[])expectedArray));
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public ListSubject<?, Long, List<Long>> asList() {
        return ListSubject.create(this.failureStrategy, this.listRepresentation());
    }
}

