/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.ant.config;

import org.apache.flex.compiler.ant.config.ConfigVariable;
import org.apache.flex.compiler.ant.config.OptionSpec;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.FlexInteger;

public class ConfigInt
extends ConfigVariable {
    private int value;
    private boolean isSet;

    public ConfigInt(OptionSpec option) {
        super(option);
        this.isSet = false;
    }

    public ConfigInt(OptionSpec option, int value) {
        super(option);
        this.set(value);
    }

    public void set(int value) {
        this.value = value;
        this.isSet = true;
    }

    @Override
    public void set(String value) {
        int intVal;
        try {
            intVal = new FlexInteger(value).intValue();
        }
        catch (NumberFormatException e) {
            throw new BuildException("Not an integer: " + value);
        }
        this.value = intVal;
        this.isSet = true;
    }

    @Override
    public boolean isSet() {
        return this.isSet;
    }

    @Override
    public void addToCommandline(Commandline cmdline) {
        if (this.isSet) {
            cmdline.createArgument().setValue("-" + this.spec.getFullName());
            cmdline.createArgument().setValue(String.valueOf(this.value));
        }
    }
}

