/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.tree.mxml;

import org.apache.flex.compiler.internal.parsing.as.ASParser;
import org.apache.flex.compiler.internal.tree.as.NodeBase;
import org.apache.flex.compiler.internal.tree.as.metadata.MetaTagsNode;
import org.apache.flex.compiler.internal.tree.mxml.MXMLNodeBase;
import org.apache.flex.compiler.internal.tree.mxml.MXMLTreeBuilder;
import org.apache.flex.compiler.mxml.IMXMLTagData;
import org.apache.flex.compiler.mxml.IMXMLTextData;
import org.apache.flex.compiler.mxml.IMXMLUnitData;
import org.apache.flex.compiler.tree.ASTNodeID;
import org.apache.flex.compiler.tree.as.IASNode;
import org.apache.flex.compiler.tree.metadata.IMetaTagNode;
import org.apache.flex.compiler.tree.mxml.IMXMLMetadataNode;

class MXMLMetadataNode
extends MXMLNodeBase
implements IMXMLMetadataNode {
    private IMetaTagNode[] metaTagNodes;

    MXMLMetadataNode(NodeBase parent) {
        super(parent);
    }

    @Override
    public ASTNodeID getNodeID() {
        return ASTNodeID.MXMLMetadataID;
    }

    @Override
    public IASNode getChild(int i) {
        return this.metaTagNodes != null ? this.metaTagNodes[i] : null;
    }

    @Override
    public int getChildCount() {
        return this.metaTagNodes != null ? this.metaTagNodes.length : 0;
    }

    @Override
    public String getName() {
        return "Metadata";
    }

    @Override
    public IMetaTagNode[] getMetaTagNodes() {
        return this.metaTagNodes;
    }

    @Override
    protected void processChildNonWhitespaceUnit(MXMLTreeBuilder builder, IMXMLTagData tag, IMXMLTextData text, MXMLNodeBase.MXMLNodeInfo info) {
    }

    @Override
    protected void initializationComplete(MXMLTreeBuilder builder, IMXMLTagData tag, MXMLNodeBase.MXMLNodeInfo info) {
        for (IMXMLUnitData unit = tag.getFirstChildUnit(); unit != null; unit = unit.getNextSiblingUnit()) {
            IMXMLTextData mxmlTextData;
            if (!(unit instanceof IMXMLTextData) || (mxmlTextData = (IMXMLTextData)unit).getTextType() == IMXMLTextData.TextType.WHITESPACE) continue;
            MetaTagsNode metaTagsNode = ASParser.parseMetadata(builder.getWorkspace(), mxmlTextData.getCompilableText(), mxmlTextData.getSourcePath(), mxmlTextData.getCompilableTextStart(), mxmlTextData.getCompilableTextLine(), mxmlTextData.getCompilableTextColumn(), builder.getProblems());
            if (metaTagsNode == null) {
                this.metaTagNodes = null;
                return;
            }
            int n = metaTagsNode.getChildCount();
            this.metaTagNodes = new IMetaTagNode[n];
            for (int i = 0; i < n; ++i) {
                IMetaTagNode child;
                this.metaTagNodes[i] = child = (IMetaTagNode)metaTagsNode.getChild(i);
                ((NodeBase)((Object)child)).setParent(this);
            }
        }
    }
}

