/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.tree.mxml;

import org.apache.flex.compiler.internal.tree.as.NodeBase;
import org.apache.flex.compiler.internal.tree.mxml.MXMLExpressionNodeBase;
import org.apache.flex.compiler.internal.tree.mxml.MXMLLiteralNode;
import org.apache.flex.compiler.internal.tree.mxml.MXMLNodeBase;
import org.apache.flex.compiler.internal.tree.mxml.MXMLTreeBuilder;
import org.apache.flex.compiler.mxml.IMXMLTagData;
import org.apache.flex.compiler.tree.ASTNodeID;
import org.apache.flex.compiler.tree.mxml.IMXMLBooleanNode;

class MXMLBooleanNode
extends MXMLExpressionNodeBase
implements IMXMLBooleanNode {
    private static final Boolean DEFAULT = Boolean.FALSE;

    MXMLBooleanNode(NodeBase parent) {
        super(parent);
    }

    @Override
    public ASTNodeID getNodeID() {
        return ASTNodeID.MXMLBooleanID;
    }

    @Override
    public String getName() {
        return "Boolean";
    }

    @Override
    public boolean getValue() {
        assert (this.getExpressionNode() == null || this.getExpressionNode() instanceof MXMLLiteralNode) : "getValue() shouldn't be getting called on a non-literal MXMLBooleanNode";
        MXMLLiteralNode literalNode = (MXMLLiteralNode)this.getExpressionNode();
        return literalNode != null ? (Boolean)literalNode.getValue() : false;
    }

    @Override
    public MXMLExpressionNodeBase.ExpressionType getExpressionType() {
        return MXMLExpressionNodeBase.ExpressionType.BOOLEAN;
    }

    @Override
    protected void initializationComplete(MXMLTreeBuilder builder, IMXMLTagData tag, MXMLNodeBase.MXMLNodeInfo info) {
        NodeBase expressionNode = this.createExpressionNodeFromFragments(builder, tag, info, DEFAULT);
        this.setExpressionNode(expressionNode);
        super.initializationComplete(builder, tag, info);
    }
}

