/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.tree.as.metadata;

import antlr.Token;
import org.apache.flex.compiler.internal.parsing.TokenBase;
import org.apache.flex.compiler.internal.tree.as.IdentifierNode;
import org.apache.flex.compiler.internal.tree.as.QualifiedNameExpressionNode;
import org.apache.flex.compiler.internal.tree.as.metadata.MetaTagNode;
import org.apache.flex.compiler.tree.metadata.IInspectableTagNode;
import org.apache.flex.utils.CheapArray;

public class InspectableTagNode
extends MetaTagNode
implements IInspectableTagNode {
    private static final String[] EMPTY_ARRAY = new String[0];
    private IdentifierNode variable;
    private IdentifierNode arrayType;
    private Object values = CheapArray.create(5);
    private IdentifierNode type;

    public InspectableTagNode() {
        super("Inspectable");
    }

    @Override
    protected void setChildren(boolean fillInOffsets) {
        this.addChildInOrder(this.variable, fillInOffsets);
        this.addChildInOrder(this.arrayType, fillInOffsets);
        this.addChildInOrder(this.type, fillInOffsets);
    }

    @Override
    protected int getInitialChildCount() {
        return 0;
    }

    @Override
    public void normalize(boolean fillInOffsets) {
        super.normalize(fillInOffsets);
        this.values = CheapArray.optimize(this.values, EMPTY_ARRAY);
    }

    @Override
    public String[] getAllowedValues() {
        return (String[])CheapArray.toArray(this.values, EMPTY_ARRAY);
    }

    public void addAllowedValue(String value) {
        CheapArray.add(value, this.values);
        String string = this.getValue("enumeration");
        if (string.length() > 0) {
            string = string + ",";
        }
        string = string + value;
        this.addToMap("enumeration", value);
    }

    public void parseValues(String valueString) {
        if (valueString != null) {
            String[] strings = valueString.split(",");
            for (int i = 0; i < strings.length; ++i) {
                CheapArray.add(strings[i].trim(), this.values);
            }
        }
        this.addToMap("enumeration", valueString);
    }

    public void setCategory(String category) {
        this.addToMap("category", category);
    }

    public String getCategory() {
        return this.getValue("category");
    }

    public String getDefaultValue() {
        return this.getValue("defaultValue");
    }

    public void setDefaultValue(String value) {
        this.addToMap("defaultValue", value);
    }

    public void setEnvironment(String environment) {
        this.addToMap("environment", environment);
    }

    @Override
    public String getEnvironment() {
        return this.getValue("environment");
    }

    @Override
    public String getFormat() {
        return this.getValue("format");
    }

    public void setFormat(String format) {
        this.addToMap("format", format);
    }

    @Override
    public String getName() {
        return this.getValue("name");
    }

    public void setName(String name) {
        this.addToMap("name", name);
    }

    private String getTypeName() {
        return this.type != null ? this.type.getName() : "";
    }

    public void setType(Token type) {
        this.type = new QualifiedNameExpressionNode((TokenBase)type);
        this.type.setParent(this);
        this.addToMap("type", this.getTypeName());
    }

    @Override
    public String getVariable() {
        return this.variable != null ? this.variable.getName() : "";
    }

    public void setVariable(IdentifierNode variable) {
        this.variable = variable;
        this.variable.setParent(this);
        this.addToMap("variable", this.getVariable());
    }

    public void setVerbose(String verbose) {
        this.addToMap("verbose", verbose);
    }

    @Override
    public String getVerbose() {
        return this.getValue("verbose");
    }

    public void setArrayType(IdentifierNode arrayType) {
        this.arrayType = arrayType;
        this.arrayType.setParent(this);
        this.addToMap("arrayType", this.getArrayType());
    }

    @Override
    public String getArrayType() {
        return this.arrayType != null ? this.arrayType.getName() : "";
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof InspectableTagNode) {
            if (!this.equals(((InspectableTagNode)obj).arrayType, this.arrayType)) {
                return false;
            }
            if (!this.equals(((InspectableTagNode)obj).type, this.type)) {
                return false;
            }
            if (!this.equals(((InspectableTagNode)obj).variable, this.variable)) {
                return false;
            }
        } else {
            return false;
        }
        return super.equals(obj);
    }
}

