/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.projects;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.flex.compiler.definitions.IDefinition;
import org.apache.flex.compiler.internal.parsing.as.ASParser;
import org.apache.flex.compiler.internal.parsing.as.IProjectConfigVariables;
import org.apache.flex.compiler.internal.projects.CompilerProject;
import org.apache.flex.compiler.internal.tree.as.ConfigConstNode;
import org.apache.flex.compiler.internal.tree.as.ConfigNamespaceNode;
import org.apache.flex.compiler.problems.ICompilerProblem;
import org.apache.flex.compiler.tree.as.IASNode;

public final class ConfigManager {
    private LinkedHashMap<String, String> configMapping = new LinkedHashMap();
    private boolean validated = false;

    public void addConfigVariable(String namespace, String expression) {
        this.configMapping.put(namespace, expression);
        this.validated = false;
    }

    public void addConfigVariables(Map<String, String> variables) {
        this.configMapping.putAll(variables);
        this.validated = false;
    }

    public IProjectConfigVariables getProjectConfig(CompilerProject project) {
        LinkedHashMap<String, String> configValues = new LinkedHashMap<String, String>();
        configValues.putAll(this.configMapping);
        ProjectVariables vars = new ProjectVariables(project, configValues);
        if (!this.validated) {
            vars.getProblems();
            this.validated = true;
        }
        return vars;
    }

    private final class ProjectVariables
    implements IProjectConfigVariables {
        private CompilerProject project;
        private Map<String, String> configValues;
        private ArrayList<IDefinition> definitions;
        private ArrayList<ConfigConstNode> constNodes;
        private ArrayList<ConfigNamespaceNode> configNamespaces;
        private ArrayList<String> nsNames;
        private ArrayList<ICompilerProblem> problems;

        public ProjectVariables(CompilerProject project, Map<String, String> configValues) {
            this.project = project;
            this.configValues = configValues;
        }

        @Override
        public List<IDefinition> getRequiredDefinitions() {
            if (this.definitions == null) {
                this.definitions = new ArrayList(5);
                this.definitions.add(this.project.getScope().findDefinitionByName("Boolean"));
                this.definitions.add(this.project.getScope().findDefinitionByName("String"));
                this.definitions.add(this.project.getScope().findDefinitionByName("uint"));
                this.definitions.add(this.project.getScope().findDefinitionByName("int"));
                this.definitions.add(this.project.getScope().findDefinitionByName("Number"));
            }
            return this.definitions;
        }

        private synchronized void loadConfigData() {
            IASNode[] nodes;
            this.problems = new ArrayList();
            HashSet<String> nsNames = new HashSet<String>();
            this.constNodes = new ArrayList();
            this.configNamespaces = new ArrayList();
            StringBuilder cn = new StringBuilder();
            for (String next : this.configValues.keySet()) {
                int q = next.indexOf("::");
                if (q == -1) continue;
                String subSequence = next.substring(0, q);
                cn.append("config");
                cn.append(" ");
                cn.append("namespace");
                cn.append(" ");
                cn.append(subSequence);
                cn.append(";");
                cn.append(subSequence);
                cn.append(" ");
                cn.append("const");
                cn.append(" ");
                cn.append(next.substring(q + 2));
                cn.append("=");
                cn.append((String)ConfigManager.this.configMapping.get(next));
                cn.append(";");
            }
            for (IASNode node : nodes = ASParser.parseProjectConfigVariables(this.project.getWorkspace(), cn.toString(), this.problems)) {
                if (node instanceof ConfigConstNode) {
                    this.constNodes.add((ConfigConstNode)node);
                    continue;
                }
                if (!(node instanceof ConfigNamespaceNode) || nsNames.contains(((ConfigNamespaceNode)node).getName())) continue;
                this.configNamespaces.add((ConfigNamespaceNode)node);
                nsNames.add(((ConfigNamespaceNode)node).getName());
            }
            this.nsNames = new ArrayList(nsNames.size());
            this.nsNames.addAll(nsNames);
        }

        @Override
        public boolean equals(IProjectConfigVariables other) {
            if (other instanceof ProjectVariables) {
                return this.configValues.hashCode() == ((ProjectVariables)other).hashCode();
            }
            return other == this;
        }

        @Override
        public List<ConfigConstNode> getConfigVariables() {
            if (this.constNodes == null) {
                this.loadConfigData();
            }
            return this.constNodes;
        }

        @Override
        public List<ConfigNamespaceNode> getConfigNamespaces() {
            if (this.configNamespaces == null) {
                this.loadConfigData();
            }
            return this.configNamespaces;
        }

        @Override
        public List<String> getConfigNamespaceNames() {
            if (this.nsNames == null) {
                this.loadConfigData();
            }
            return this.nsNames;
        }

        @Override
        public Collection<ICompilerProblem> getProblems() {
            if (this.problems == null) {
                this.loadConfigData();
            }
            return this.problems;
        }
    }
}

