/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.graph;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.TransformerException;
import org.apache.flex.compiler.common.DependencyType;
import org.apache.flex.compiler.common.DependencyTypeSet;
import org.apache.flex.compiler.definitions.IDefinition;
import org.apache.flex.compiler.internal.graph.IReportWriter;
import org.apache.flex.compiler.internal.graph.InvalidationBytesCalculator;
import org.apache.flex.compiler.internal.graph.XMLGraphWriter;
import org.apache.flex.compiler.internal.projects.DependencyGraph;
import org.apache.flex.compiler.internal.targets.LinkageChecker;
import org.apache.flex.compiler.problems.ICompilerProblem;
import org.apache.flex.compiler.problems.UnableToBuildReportProblem;
import org.apache.flex.compiler.units.ICompilationUnit;
import org.w3c.dom.Element;

public class LinkReportWriter
extends XMLGraphWriter
implements IReportWriter {
    private final LinkageChecker linkageChecker;

    public LinkReportWriter(DependencyGraph graph, List<ICompilationUnit> roots, LinkageChecker linkageChecker) {
        super(graph, roots);
        this.linkageChecker = linkageChecker;
    }

    private void addScriptDependencies(Element script, Map<String, DependencyTypeSet> dependencies) {
        ArrayList<Element> prereqNodes = new ArrayList<Element>();
        ArrayList<Element> dependencyNodes = new ArrayList<Element>();
        ArrayList<String> dependencyQNames = new ArrayList<String>(dependencies.keySet());
        Collections.sort(dependencyQNames, new QNameComparator());
        for (String qname : dependencyQNames) {
            Element preNode;
            if (qname.isEmpty()) continue;
            String xmlStyleQName = this.formatXMLStyleQName(qname);
            DependencyTypeSet dependencySet = dependencies.get(qname);
            String typeString = DependencyType.getTypeString(dependencySet);
            if (DependencyType.INHERITANCE.existsIn(dependencySet)) {
                preNode = this.doc.createElement("pre");
                preNode.setAttribute("id", xmlStyleQName);
                preNode.setAttribute("type", typeString);
                prereqNodes.add(preNode);
                continue;
            }
            preNode = this.doc.createElement("dep");
            preNode.setAttribute("id", xmlStyleQName);
            preNode.setAttribute("type", typeString);
            dependencyNodes.add(preNode);
        }
        for (Element tag : prereqNodes) {
            script.appendChild(tag);
        }
        for (Element tag : dependencyNodes) {
            script.appendChild(tag);
        }
    }

    private Element createScriptTag(int bytecodeSize, ICompilationUnit cu) throws InterruptedException {
        Element script = this.doc.createElement("script");
        script.setAttribute("name", cu.getName());
        script.setAttribute("mod", String.valueOf(cu.getSyntaxTreeRequest().get().getLastModified()));
        script.setAttribute("size", Integer.toString(bytecodeSize));
        Collection<IDefinition> definitions = cu.getFileScopeRequest().get().getExternallyVisibleDefinitions();
        ArrayList<String> defQNames = new ArrayList<String>();
        for (IDefinition definition : definitions) {
            String xmlStyleQName = this.formatXMLStyleQName(definition.getQualifiedName());
            defQNames.add(xmlStyleQName);
        }
        Collections.sort(defQNames, new QNameComparator());
        for (String definitionQName : defQNames) {
            Element definition = this.doc.createElement("def");
            script.appendChild(definition);
            definition.setAttribute("id", definitionQName);
        }
        return script;
    }

    private Map<String, DependencyTypeSet> readEdges(Set<String> externalDefs, ICompilationUnit cu) throws InterruptedException {
        HashMap<String, DependencyTypeSet> dependencies = new HashMap<String, DependencyTypeSet>();
        Set<ICompilationUnit> dependentUnits = this.graph.getDirectDependencies(cu);
        for (ICompilationUnit dependentUnit : dependentUnits) {
            Map<String, DependencyTypeSet> edgeDeps = this.graph.getDependencySet(cu, dependentUnit);
            dependencies.putAll(edgeDeps);
            Set<String> edgeQNames = edgeDeps.keySet();
            if (!this.isLinkageExternal(dependentUnit)) continue;
            externalDefs.addAll(edgeQNames);
        }
        return dependencies;
    }

    private List<ICompilationUnit> extractSortedInternalUnits() throws InterruptedException {
        ArrayList<ICompilationUnit> internalUnits = new ArrayList<ICompilationUnit>();
        List<ICompilationUnit> vertices = this.graph.topologicalSort(this.roots);
        Collections.reverse(vertices);
        for (ICompilationUnit vertex : vertices) {
            if (this.isLinkageExternal(vertex)) continue;
            internalUnits.add(vertex);
        }
        return internalUnits;
    }

    private boolean isLinkageExternal(ICompilationUnit cu) throws InterruptedException {
        return cu.getCompilationUnitType() == ICompilationUnit.UnitType.SWC_UNIT && this.linkageChecker.isExternal(cu);
    }

    @Override
    public void writeToStream(OutputStream outStream, Collection<ICompilerProblem> problems) throws InterruptedException {
        List<ICompilationUnit> internalUnits = this.extractSortedInternalUnits();
        Map<ICompilationUnit, Integer> bytecodeSizes = InvalidationBytesCalculator.calculateBytesChanged(internalUnits);
        HashSet<String> externalDefs = new HashSet<String>();
        Element scripts = this.doc.createElement("scripts");
        for (ICompilationUnit cu : internalUnits) {
            Element script = this.createScriptTag(bytecodeSizes.get(cu), cu);
            this.addScriptDependencies(script, this.readEdges(externalDefs, cu));
            scripts.appendChild(script);
        }
        Element externalDefinitions = this.doc.createElement("external-defs");
        ArrayList extDefinitionList = new ArrayList(externalDefs);
        Collections.sort(extDefinitionList, new QNameComparator());
        for (String ext : extDefinitionList) {
            Element extNode = this.doc.createElement("ext");
            extNode.setAttribute("id", this.formatXMLStyleQName(ext));
            externalDefinitions.appendChild(extNode);
        }
        Element report = this.doc.createElement("report");
        report.appendChild(scripts);
        report.appendChild(externalDefinitions);
        this.doc.appendChild(report);
        try {
            this.writeReport(outStream);
        }
        catch (TransformerException e) {
            problems.add(new UnableToBuildReportProblem(e));
        }
    }

    public static class QNameComparator
    implements Comparator<String> {
        @Override
        public int compare(String a, String b) {
            boolean bSingleNamed;
            boolean aSingleNamed = a.lastIndexOf(46) == -1;
            boolean bl = bSingleNamed = b.lastIndexOf(46) == -1;
            if (aSingleNamed == bSingleNamed) {
                return a.compareTo(b);
            }
            return aSingleNamed ? 1 : -1;
        }
    }
}

