/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.embedding.transcoders;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.PixelGrabber;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.flex.compiler.common.ISourceLocation;
import org.apache.flex.compiler.internal.embedding.EmbedAttribute;
import org.apache.flex.compiler.internal.embedding.EmbedData;
import org.apache.flex.compiler.internal.embedding.transcoders.ScalableTranscoder;
import org.apache.flex.compiler.internal.workspaces.Workspace;
import org.apache.flex.compiler.problems.EmbedExceptionWhileTranscodingProblem;
import org.apache.flex.compiler.problems.ICompilerProblem;
import org.apache.flex.swf.tags.CharacterTag;
import org.apache.flex.swf.tags.DefineBitsJPEG2Tag;
import org.apache.flex.swf.tags.DefineBitsTag;
import org.apache.flex.swf.tags.DefineScalingGridTag;
import org.apache.flex.swf.tags.DefineShape4Tag;
import org.apache.flex.swf.tags.DefineShapeTag;
import org.apache.flex.swf.tags.DefineSpriteTag;
import org.apache.flex.swf.tags.ICharacterTag;
import org.apache.flex.swf.tags.ITag;
import org.apache.flex.swf.tags.PlaceObject2Tag;
import org.apache.flex.swf.types.FillStyle;
import org.apache.flex.swf.types.FillStyleArray;
import org.apache.flex.swf.types.IFillStyle;
import org.apache.flex.swf.types.LineStyleArray;
import org.apache.flex.swf.types.Matrix;
import org.apache.flex.swf.types.Rect;
import org.apache.flex.swf.types.ShapeWithStyle;
import org.apache.flex.swf.types.StraightEdgeRecord;
import org.apache.flex.swf.types.StyleChangeRecord;
import org.apache.flex.swf.types.Styles;

public class ImageTranscoder
extends ScalableTranscoder {
    private boolean smoothing = false;

    public ImageTranscoder(EmbedData data, Workspace workspace) {
        super(data, workspace);
    }

    @Override
    public boolean analyze(ISourceLocation location, Collection<ICompilerProblem> problems) {
        boolean result = super.analyze(location, problems);
        this.baseClassQName = this.scaling || this.smoothing ? "mx.core.SpriteAsset" : "mx.core.BitmapAsset";
        return result;
    }

    @Override
    protected boolean setAttribute(EmbedAttribute attribute) {
        boolean isSupported = true;
        switch (attribute) {
            case SMOOTHING: {
                this.smoothing = (Boolean)this.data.getAttribute(EmbedAttribute.SMOOTHING);
                break;
            }
            default: {
                isSupported = super.setAttribute(attribute);
            }
        }
        return isSupported;
    }

    @Override
    protected Map<String, ICharacterTag> doTranscode(Collection<ITag> tags, Collection<ICompilerProblem> problems) {
        DefineBitsTag image;
        byte[] bytes = this.getDataBytes(problems);
        if (bytes == null) {
            return null;
        }
        ImageInfo imageInfo = null;
        if (this.scaling || this.smoothing) {
            try {
                imageInfo = this.getImageInfo(bytes, problems);
            }
            catch (Exception e) {
                problems.add(new EmbedExceptionWhileTranscodingProblem(e));
                return null;
            }
        }
        if ((image = this.buildImage(bytes, problems)) == null) {
            return null;
        }
        CharacterTag assetTag = this.scaling ? this.buildSlicedSprite(image, imageInfo.widthInTwips, imageInfo.heightInTwips, tags, problems) : (this.smoothing ? this.buildSmoothingSprite(image, imageInfo.widthInTwips, imageInfo.heightInTwips, tags, problems) : image);
        if (assetTag == null) {
            return null;
        }
        Map<String, ICharacterTag> symbolTags = Collections.singletonMap(this.data.getQName(), assetTag);
        return symbolTags;
    }

    protected ImageInfo getImageInfo(byte[] bytes, Collection<ICompilerProblem> problems) throws Exception {
        Image image = Toolkit.getDefaultToolkit().createImage(bytes);
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, -1, -1, true);
        pixelGrabber.grabPixels();
        ImageInfo imageInfo = new ImageInfo(pixelGrabber);
        return imageInfo;
    }

    private DefineSpriteTag buildSlicedSprite(DefineBitsTag image, int width, int height, Collection<ITag> tags, Collection<ICompilerProblem> problems) {
        DefineScalingGridTag scalingGrid = this.buildScalingGrid();
        DefineShapeTag shape = this.buildSlicedShape(image, scalingGrid.getSplitter(), width, height);
        return this.buildSprite(image, shape, scalingGrid, tags);
    }

    private DefineSpriteTag buildSmoothingSprite(DefineBitsTag image, int width, int height, Collection<ITag> tags, Collection<ICompilerProblem> problems) {
        DefineShapeTag shape = this.buildSmoothingShape(image, width, height);
        return this.buildSprite(image, shape, null, tags);
    }

    private DefineBitsTag buildImage(byte[] bytes, Collection<ICompilerProblem> problems) {
        DefineBitsJPEG2Tag tag = new DefineBitsJPEG2Tag();
        tag.setImageData(bytes);
        return tag;
    }

    private DefineSpriteTag buildSprite(DefineBitsTag image, DefineShapeTag shape, DefineScalingGridTag scalingGrid, Collection<ITag> tags) {
        tags.add(image);
        Matrix tm = new Matrix();
        tm.setScale(1.0, 1.0);
        PlaceObject2Tag po = new PlaceObject2Tag();
        po.setDepth(10);
        po.setCharacter(shape);
        po.setHasCharacter(true);
        po.setMatrix(tm);
        po.setHasMatrix(true);
        ArrayList<ITag> spriteTags = new ArrayList<ITag>(1);
        spriteTags.add(po);
        int frameCount = 0;
        DefineSpriteTag sprite = this.buildSprite(spriteTags, frameCount, scalingGrid, tags);
        tags.add(shape);
        return sprite;
    }

    private DefineShapeTag buildSlicedShape(DefineBitsTag image, Rect r, int width, int height) {
        DefineShape4Tag shape = new DefineShape4Tag();
        Rect bounds = new Rect(0, width, 0, height);
        shape.setShapeBounds(bounds);
        shape.setEdgeBounds(bounds);
        FillStyleArray fillStyles = new FillStyleArray();
        LineStyleArray lineStyles = new LineStyleArray();
        Styles styles = new Styles(fillStyles, lineStyles);
        ShapeWithStyle shapeWithStyle = new ShapeWithStyle(styles);
        shape.setShapes(shapeWithStyle);
        Matrix tsm = new Matrix();
        tsm.setScale(20.0, 20.0);
        for (int i = 0; i < 9; ++i) {
            FillStyle fs = new FillStyle();
            fs.setBitmapCharacter(image);
            fs.setBitmapMatrix(tsm);
            fs.setFillStyleType(66);
            fillStyles.add(fs);
        }
        int slt = r.xMin();
        int srt = r.xMax();
        int stt = r.yMin();
        int sbt = r.yMax();
        int dxa = slt;
        int dxb = srt - slt;
        int dxc = width - srt;
        int dya = stt;
        int dyb = sbt - stt;
        int dyc = height - sbt;
        StyleChangeRecord startStyle = new StyleChangeRecord();
        startStyle.setMove(0, dya);
        shapeWithStyle.addShapeRecord(startStyle);
        this.addEdgesWithFill(styles, shapeWithStyle, new int[][]{{0, -dya}, {dxa, 0}}, 0, 1);
        this.addEdgesWithFill(styles, shapeWithStyle, new int[][]{{dxb, 0}}, 0, 2);
        this.addEdgesWithFill(styles, shapeWithStyle, new int[][]{{dxc, 0}, {0, dya}}, 0, 3);
        this.addEdgesWithFill(styles, shapeWithStyle, new int[][]{{0, dyb}}, 0, 6);
        this.addEdgesWithFill(styles, shapeWithStyle, new int[][]{{0, dyc}, {-dxc, 0}}, 0, 9);
        this.addEdgesWithFill(styles, shapeWithStyle, new int[][]{{-dxb, 0}}, 0, 8);
        this.addEdgesWithFill(styles, shapeWithStyle, new int[][]{{-dxa, 0}, {0, -dyc}}, 0, 7);
        this.addEdgesWithFill(styles, shapeWithStyle, new int[][]{{0, -dyb}}, 0, 4);
        StyleChangeRecord down1Style = new StyleChangeRecord();
        down1Style.setMove(dxa, 0);
        shapeWithStyle.addShapeRecord(down1Style);
        this.addEdgesWithFill(styles, shapeWithStyle, new int[][]{{0, dya}}, 2, 1);
        this.addEdgesWithFill(styles, shapeWithStyle, new int[][]{{0, dyb}}, 5, 4);
        this.addEdgesWithFill(styles, shapeWithStyle, new int[][]{{0, dyc}}, 8, 7);
        StyleChangeRecord down2Style = new StyleChangeRecord();
        down2Style.setMove(dxa + dxb, 0);
        shapeWithStyle.addShapeRecord(down2Style);
        this.addEdgesWithFill(styles, shapeWithStyle, new int[][]{{0, dya}}, 3, 2);
        this.addEdgesWithFill(styles, shapeWithStyle, new int[][]{{0, dyb}}, 6, 5);
        this.addEdgesWithFill(styles, shapeWithStyle, new int[][]{{0, dyc}}, 9, 8);
        StyleChangeRecord right1Style = new StyleChangeRecord();
        right1Style.setMove(0, dya);
        shapeWithStyle.addShapeRecord(right1Style);
        this.addEdgesWithFill(styles, shapeWithStyle, new int[][]{{dxa, 0}}, 1, 4);
        this.addEdgesWithFill(styles, shapeWithStyle, new int[][]{{dxb, 0}}, 2, 5);
        this.addEdgesWithFill(styles, shapeWithStyle, new int[][]{{dxc, 0}}, 3, 6);
        StyleChangeRecord right2Style = new StyleChangeRecord();
        right2Style.setMove(0, dya + dyb);
        shapeWithStyle.addShapeRecord(right2Style);
        this.addEdgesWithFill(styles, shapeWithStyle, new int[][]{{dxa, 0}}, 4, 7);
        this.addEdgesWithFill(styles, shapeWithStyle, new int[][]{{dxb, 0}}, 5, 8);
        this.addEdgesWithFill(styles, shapeWithStyle, new int[][]{{dxc, 0}}, 6, 9);
        return shape;
    }

    private DefineShapeTag buildSmoothingShape(DefineBitsTag image, int width, int height) {
        DefineShapeTag shape = new DefineShapeTag();
        Rect bounds = new Rect(0, width, 0, height);
        shape.setShapeBounds(bounds);
        FillStyleArray fillStyles = new FillStyleArray();
        LineStyleArray lineStyles = new LineStyleArray();
        Styles styles = new Styles(fillStyles, lineStyles);
        ShapeWithStyle shapeWithStyle = new ShapeWithStyle(styles);
        shape.setShapes(shapeWithStyle);
        Matrix tsm = new Matrix();
        tsm.setScale(20.0, 20.0);
        FillStyle fs = new FillStyle();
        fs.setBitmapCharacter(image);
        fs.setBitmapMatrix(tsm);
        fs.setFillStyleType(65);
        fillStyles.add(fs);
        StyleChangeRecord startStyle = new StyleChangeRecord();
        startStyle.setDefinedStyles(null, fs, null, styles);
        startStyle.setMove(width, height);
        shapeWithStyle.addShapeRecord(startStyle);
        shapeWithStyle.addShapeRecord(new StraightEdgeRecord(-1 * width, 0));
        shapeWithStyle.addShapeRecord(new StraightEdgeRecord(0, -1 * height));
        shapeWithStyle.addShapeRecord(new StraightEdgeRecord(width, 0));
        shapeWithStyle.addShapeRecord(new StraightEdgeRecord(0, height));
        return shape;
    }

    private void addEdgesWithFill(Styles styles, ShapeWithStyle shapeWithStyle, int[][] coords, int left, int right) {
        StyleChangeRecord scr = new StyleChangeRecord();
        if (left != 0 || right != 0) {
            IFillStyle fillStyle0 = null;
            if (left > 0) {
                fillStyle0 = (IFillStyle)styles.getFillStyles().get(left - 1);
            }
            IFillStyle fillStyle1 = null;
            if (right > 0) {
                fillStyle1 = (IFillStyle)styles.getFillStyles().get(right - 1);
            }
            scr.setDefinedStyles(fillStyle0, fillStyle1, null, styles);
        }
        shapeWithStyle.addShapeRecord(scr);
        for (int i = 0; i < coords.length; ++i) {
            shapeWithStyle.addShapeRecord(new StraightEdgeRecord(coords[i][0], coords[i][1]));
        }
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof ImageTranscoder)) {
            return false;
        }
        ImageTranscoder t = (ImageTranscoder)o;
        return this.smoothing == t.smoothing;
    }

    @Override
    public int hashCode() {
        int hashCode = super.hashCode();
        return hashCode += this.smoothing ? 1 : 0;
    }

    protected static class ImageInfo {
        public final PixelGrabber pixelGrabber;
        public final int width;
        public final int height;
        public final int widthInTwips;
        public final int heightInTwips;

        public ImageInfo(PixelGrabber pixelGrabber) {
            this.pixelGrabber = pixelGrabber;
            this.width = pixelGrabber.getWidth();
            this.height = pixelGrabber.getHeight();
            this.widthInTwips = this.width * 20;
            this.heightInTwips = this.height * 20;
        }
    }
}

