/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.css;

import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.apache.flex.compiler.internal.css.CSSColorPropertyValue;
import org.apache.flex.compiler.internal.css.CSSModelTreeType;
import org.apache.flex.compiler.internal.css.CSSPropertyValue;

public class CSSKeywordPropertyValue
extends CSSPropertyValue {
    private final String keyword;

    protected static CSSPropertyValue create(CommonTree tree, TokenStream tokenStream) {
        assert (tree != null) : "AST can't be null.";
        assert (tokenStream != null) : "TokenStream can't be null.";
        String keyword = tree.getText();
        Integer colorInt = (Integer)CSSColorPropertyValue.COLOR_MAP.get((Object)keyword.toLowerCase());
        CSSPropertyValue result = colorInt != null ? new CSSColorPropertyValue(colorInt, tree, tokenStream) : new CSSKeywordPropertyValue(tree, tokenStream);
        return result;
    }

    protected CSSKeywordPropertyValue(CommonTree tree, TokenStream tokenStream) {
        super(tree, tokenStream, CSSModelTreeType.PROPERTY_VALUE);
        this.keyword = tree.getText();
    }

    public String getKeyword() {
        return this.keyword;
    }

    @Override
    public String toString() {
        return this.keyword;
    }
}

