/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.config;

import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.flex.compiler.config.ConfigurationBuffer;
import org.apache.flex.compiler.exceptions.ConfigurationException;

public class SystemPropertyConfigurator {
    public static void load(ConfigurationBuffer buffer, String prefix) throws ConfigurationException {
        try {
            Properties props = System.getProperties();
            Enumeration<?> e = props.propertyNames();
            while (e.hasMoreElements()) {
                String propname = (String)e.nextElement();
                if (!propname.startsWith(prefix + ".")) {
                    String value = System.getProperty(propname);
                    buffer.setToken(propname, value);
                    continue;
                }
                String varname = propname.substring(prefix.length() + 1);
                if (!buffer.isValidVar(varname)) continue;
                String value = System.getProperty(propname);
                LinkedList<String> args = new LinkedList<String>();
                StringTokenizer t = new StringTokenizer(value, ",");
                while (t.hasMoreTokens()) {
                    String token = t.nextToken();
                    args.add(token);
                }
                buffer.setVar(varname, args, "system properties", -1);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

