/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.as.codegen;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.flex.abc.ABCEmitter;
import org.apache.flex.abc.diagnostics.AbstractDiagnosticVisitor;
import org.apache.flex.abc.graph.IBasicBlock;
import org.apache.flex.abc.graph.IFlowgraph;
import org.apache.flex.abc.instructionlist.InstructionList;
import org.apache.flex.abc.semantics.MethodBodyInfo;
import org.apache.flex.abc.semantics.MethodInfo;
import org.apache.flex.abc.semantics.ScriptInfo;
import org.apache.flex.abc.visitors.IABCVisitor;
import org.apache.flex.compiler.internal.as.codegen.ICodeGenerator;
import org.apache.flex.compiler.internal.as.codegen.LexicalScope;
import org.apache.flex.compiler.internal.embedding.EmbedData;
import org.apache.flex.compiler.internal.semantics.MethodBodySemanticChecker;
import org.apache.flex.compiler.problems.ICompilerProblem;
import org.apache.flex.compiler.problems.OperandStackUnderflowProblem;
import org.apache.flex.compiler.problems.ScopeStackUnderflowProblem;
import org.apache.flex.compiler.projects.ICompilerProject;

public class GlobalLexicalScope
extends LexicalScope {
    private final ICompilerProject project;
    private final ICodeGenerator generator;
    private final IABCVisitor emitter;
    private final String syntheticNamePrefix;
    private int ticketCount = 0;
    private final boolean inInvisibleCompilationUnit;
    private final Map<String, String> encodedDebugFiles;
    public static final boolean VISIBLE_COMPILATION_UNIT = false;
    public static final boolean NO_PARALLEL_CODEGEN = false;
    public static final String EMPTY_NAME_PREFIX = "";
    public static final ICodeGenerator NO_GENERATOR = null;
    public static final IABCVisitor USE_DEFAULT_EMITTER = null;
    private final InstructionList initInstructions;
    private final Set<EmbedData> embeds;
    private final Collection<ICompilerProblem> problems;

    public GlobalLexicalScope(ICompilerProject project, ICodeGenerator generator) {
        this(project, generator, EMPTY_NAME_PREFIX, USE_DEFAULT_EMITTER, false, false, Collections.emptyMap());
    }

    public GlobalLexicalScope(ICompilerProject project, ICodeGenerator generator, String syntheticNamePrefix, IABCVisitor emitter) {
        this(project, generator, syntheticNamePrefix, emitter, false, false, Collections.emptyMap());
    }

    public GlobalLexicalScope(ICompilerProject project, ICodeGenerator generator, String syntheticNamePrefix, boolean inInvisibleCompilationUnit, boolean useParallelCodegen, Map<String, String> encodedDebugFiles) {
        this(project, generator, syntheticNamePrefix, USE_DEFAULT_EMITTER, inInvisibleCompilationUnit, useParallelCodegen, encodedDebugFiles);
    }

    private GlobalLexicalScope(ICompilerProject project, ICodeGenerator generator, String syntheticNamePrefix, IABCVisitor emitter, boolean inInvisibleCompilationUnit, boolean useParallelCodegen, Map<String, String> encodedDebugFiles) {
        this.project = project;
        this.generator = generator;
        this.syntheticNamePrefix = syntheticNamePrefix;
        this.inInvisibleCompilationUnit = inInvisibleCompilationUnit;
        this.encodedDebugFiles = encodedDebugFiles;
        this.initInstructions = new InstructionList();
        this.methodBodySemanticChecker = new MethodBodySemanticChecker(this);
        this.emitter = emitter != USE_DEFAULT_EMITTER ? emitter : new ABCEmitter(new AETDiagnosticsVisitor());
        if (useParallelCodegen) {
            this.embeds = Collections.synchronizedSet(new HashSet());
            this.problems = Collections.synchronizedList(new LinkedList());
        } else {
            this.embeds = new HashSet<EmbedData>();
            this.problems = new LinkedList<ICompilerProblem>();
        }
    }

    @Override
    public boolean isGlobalScope() {
        return true;
    }

    @Override
    public ICompilerProject getProject() {
        return this.project;
    }

    @Override
    public ICodeGenerator getGenerator() {
        return this.generator;
    }

    @Override
    IABCVisitor getEmitter() {
        return this.emitter;
    }

    @Override
    public boolean getInInvisibleCompilationUnit() {
        return this.inInvisibleCompilationUnit;
    }

    @Override
    public InstructionList getInitInstructions() {
        return this.initInstructions;
    }

    @Override
    public MethodBodySemanticChecker getMethodBodySemanticChecker() {
        return this.methodBodySemanticChecker;
    }

    @Override
    public Collection<ICompilerProblem> getProblems() {
        return this.problems;
    }

    @Override
    public void addProblem(ICompilerProblem problem) {
        this.problems.add(problem);
    }

    public Set<EmbedData> getEmbeds() {
        return this.embeds;
    }

    protected String getSyntheticName(String user_supplied) {
        return this.syntheticNamePrefix + "$" + Integer.toString(this.ticketCount++) + ":" + user_supplied;
    }

    protected String getEncodedDebugFile(String filename) {
        if (filename == null) {
            return null;
        }
        String encodedFilename = this.encodedDebugFiles.get(filename);
        if (encodedFilename == null) {
            return filename;
        }
        return encodedFilename;
    }

    private class AETDiagnosticsVisitor
    extends AbstractDiagnosticVisitor {
        private AETDiagnosticsVisitor() {
        }

        @Override
        public void operandStackUnderflow(MethodBodyInfo methodBodyInfo, IFlowgraph cfg, IBasicBlock block, int instructionIndex) {
            GlobalLexicalScope.this.problems.add(new OperandStackUnderflowProblem(cfg, block, instructionIndex));
        }

        @Override
        public void scopeStackUnderflow(MethodBodyInfo methodBodyInfo, IFlowgraph cfg, IBasicBlock block, int instructionIndex) {
            GlobalLexicalScope.this.problems.add(new ScopeStackUnderflowProblem(cfg, block, instructionIndex));
        }

        @Override
        public void unreachableBlock(MethodBodyInfo methodBodyInfo, IFlowgraph cfg, IBasicBlock block) {
            assert (false) : "unreachableBlock";
            throw new Error("unreachableBlock");
        }

        @Override
        public void tooManyDefaultParameters(MethodInfo methodInfo) {
            assert (false) : "tooManyDefaultParameters";
            throw new Error("tooManyDefaultParameters");
        }

        @Override
        public void incorrectNumberOfParameterNames(MethodInfo methodInfo) {
            assert (false) : "incorrectNumberOfParameterNames";
            throw new Error("incorrectNumberOfParameterNames");
        }

        @Override
        public void nativeMethodWithMethodBody(MethodInfo methodInfo, MethodBodyInfo methodBodyInfo) {
            assert (false) : "nativeMethodWithMethodBody";
            throw new Error("nativeMethodWithMethodBody");
        }

        @Override
        public void scriptInitWithRequiredArguments(ScriptInfo scriptInfo, MethodInfo methodInfo) {
            assert (false) : "scriptInitWithRequiredArguments";
            throw new Error("scriptInitWithRequiredArguments");
        }
    }
}

