/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.common;

import java.util.HashMap;

public class ASModifier {
    private static HashMap<String, ASModifier> LOOKUP = new HashMap(6);
    public static final ASModifier DYNAMIC = new ASModifier("dynamic", 2);
    public static final ASModifier FINAL = new ASModifier("final", 4);
    public static final ASModifier NATIVE = new ASModifier("native", 8);
    public static final ASModifier OVERRIDE = new ASModifier("override", 16);
    public static final ASModifier STATIC = new ASModifier("static", 32);
    public static final ASModifier VIRTUAL = new ASModifier("virtual", 64);
    public static final ASModifier[] MODIFIERS = new ASModifier[]{DYNAMIC, FINAL, NATIVE, OVERRIDE, STATIC, VIRTUAL};
    private String text;
    private int maskValue;

    public static ASModifier getASModifier(String text) {
        return LOOKUP.get(text);
    }

    private ASModifier(String text, int maskValue) {
        this.text = text;
        this.maskValue = maskValue;
        LOOKUP.put(text, this);
    }

    public String toString() {
        return this.text;
    }

    public int getMaskValue() {
        return this.maskValue;
    }
}

