/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler;

import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.flex.compiler.clients.problems.ProblemFormatter;

public final class Messages {
    private static final String BUNDLE_NAME = "org.apache.flex.compiler.messages";
    private static ResourceBundle resourceBundle;
    private static Locale locale;

    public static String getString(String id) {
        String message = null;
        try {
            message = Messages.getBundle().getString(id);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return message;
    }

    public static String getString(String id, Map<String, Object> parameters) {
        return ProblemFormatter.substitute(Messages.getString(id), parameters);
    }

    public static void setLocale(Locale locale) {
        Messages.locale = locale;
    }

    protected static ResourceBundle getBundle() {
        try {
            if (resourceBundle == null) {
                Locale locale = Messages.locale;
                if (locale == null) {
                    locale = Locale.getDefault();
                }
                resourceBundle = ResourceBundle.getBundle(BUNDLE_NAME, locale);
            }
        }
        catch (MissingResourceException e) {
            resourceBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.ENGLISH);
        }
        return resourceBundle;
    }
}

