/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.codegen.js.jx;

import org.apache.flex.compiler.codegen.ISubEmitter;
import org.apache.flex.compiler.codegen.js.IJSEmitter;
import org.apache.flex.compiler.common.ISourceLocation;
import org.apache.flex.compiler.definitions.IDefinition;
import org.apache.flex.compiler.definitions.IFunctionDefinition;
import org.apache.flex.compiler.definitions.INamespaceDefinition;
import org.apache.flex.compiler.definitions.IVariableDefinition;
import org.apache.flex.compiler.internal.codegen.as.ASEmitterTokens;
import org.apache.flex.compiler.internal.codegen.js.JSSubEmitter;
import org.apache.flex.compiler.internal.codegen.js.flexjs.JSFlexJSEmitter;
import org.apache.flex.compiler.internal.codegen.js.goog.JSGoogEmitterTokens;
import org.apache.flex.compiler.internal.codegen.js.utils.EmitterUtils;
import org.apache.flex.compiler.internal.definitions.AccessorDefinition;
import org.apache.flex.compiler.internal.definitions.FunctionDefinition;
import org.apache.flex.compiler.internal.definitions.TypeDefinitionBase;
import org.apache.flex.compiler.internal.tree.as.NonResolvingIdentifierNode;
import org.apache.flex.compiler.tree.ASTNodeID;
import org.apache.flex.compiler.tree.as.IASNode;
import org.apache.flex.compiler.tree.as.IFunctionNode;
import org.apache.flex.compiler.tree.as.IFunctionObjectNode;
import org.apache.flex.compiler.tree.as.IIdentifierNode;
import org.apache.flex.compiler.tree.as.IMemberAccessExpressionNode;
import org.apache.flex.compiler.utils.NativeUtils;

public class IdentifierEmitter
extends JSSubEmitter
implements ISubEmitter<IIdentifierNode> {
    public IdentifierEmitter(IJSEmitter emitter) {
        super(emitter);
    }

    @Override
    public void emit(IIdentifierNode node) {
        Object ns;
        boolean isStatic;
        if (node instanceof NonResolvingIdentifierNode) {
            this.startMapping((ISourceLocation)node);
            this.write(node.getName());
            this.endMapping((ISourceLocation)node);
            return;
        }
        IDefinition nodeDef = node.resolve(this.getProject());
        IASNode parentNode = node.getParent();
        ASTNodeID parentNodeId = parentNode.getNodeID();
        IASNode grandparentNode = parentNode.getParent();
        ASTNodeID grandparentNodeId = parentNode != null ? grandparentNode.getNodeID() : null;
        boolean identifierIsAccessorFunction = nodeDef instanceof AccessorDefinition;
        boolean identifierIsPlainFunction = nodeDef instanceof FunctionDefinition && !identifierIsAccessorFunction;
        boolean emitName = true;
        JSFlexJSEmitter fjs = (JSFlexJSEmitter)this.getEmitter();
        boolean isCustomNamespace = false;
        boolean bl = isStatic = nodeDef != null && nodeDef.isStatic();
        if (nodeDef instanceof FunctionDefinition && fjs.isCustomNamespace((FunctionDefinition)nodeDef)) {
            isCustomNamespace = true;
        }
        if (isStatic) {
            String baseName;
            String sname = nodeDef.getParent().getQualifiedName();
            if (sname.equals("Array")) {
                baseName = nodeDef.getBaseName();
                if (baseName.equals("CASEINSENSITIVE")) {
                    this.startMapping((ISourceLocation)parentNode);
                    this.write("1");
                    this.endMapping((ISourceLocation)parentNode);
                    return;
                }
                if (baseName.equals("DESCENDING")) {
                    this.startMapping((ISourceLocation)parentNode);
                    this.write("2");
                    this.endMapping((ISourceLocation)parentNode);
                    return;
                }
                if (baseName.equals("UNIQUESORT")) {
                    this.startMapping((ISourceLocation)parentNode);
                    this.write("4");
                    this.endMapping((ISourceLocation)parentNode);
                    return;
                }
                if (baseName.equals("RETURNINDEXEDARRAY")) {
                    this.startMapping((ISourceLocation)parentNode);
                    this.write("8");
                    this.endMapping((ISourceLocation)parentNode);
                    return;
                }
                if (baseName.equals("NUMERIC")) {
                    this.startMapping((ISourceLocation)parentNode);
                    this.write("16");
                    this.endMapping((ISourceLocation)parentNode);
                    return;
                }
            } else if (sname.equals("int")) {
                baseName = nodeDef.getBaseName();
                if (baseName.equals("MAX_VALUE")) {
                    this.startMapping((ISourceLocation)parentNode);
                    this.write("2147483648");
                    this.endMapping((ISourceLocation)parentNode);
                    return;
                }
                if (baseName.equals("MIN_VALUE")) {
                    this.startMapping((ISourceLocation)parentNode);
                    this.write("-2147483648");
                    this.endMapping((ISourceLocation)parentNode);
                    return;
                }
            } else if (sname.equals("uint")) {
                baseName = nodeDef.getBaseName();
                if (baseName.equals("MAX_VALUE")) {
                    this.startMapping((ISourceLocation)parentNode);
                    this.write("4294967295");
                    this.endMapping((ISourceLocation)parentNode);
                    return;
                }
                if (baseName.equals("MIN_VALUE")) {
                    this.startMapping((ISourceLocation)parentNode);
                    this.write("0");
                    this.endMapping((ISourceLocation)parentNode);
                    return;
                }
            }
            if (sname.length() > 0) {
                IASNode prevSibling = parentNode.getChild(0);
                if (prevSibling == node) {
                    this.startMapping((ISourceLocation)parentNode);
                } else {
                    this.startMapping((ISourceLocation)prevSibling);
                }
                this.write(this.getEmitter().formatQualifiedName(sname));
                if (prevSibling != node) {
                    this.endMapping((ISourceLocation)prevSibling);
                    this.startMapping((ISourceLocation)parentNode, (ISourceLocation)prevSibling);
                }
                if (!(isCustomNamespace || identifierIsAccessorFunction && isStatic)) {
                    this.write(ASEmitterTokens.MEMBER_ACCESS);
                }
                this.endMapping((ISourceLocation)parentNode);
            }
        } else if (!NativeUtils.isNative(node.getName())) {
            boolean generateClosure;
            boolean identifierIsLocalOrInstanceFunctionAsValue = false;
            if (identifierIsPlainFunction) {
                IFunctionDefinition.FunctionClassification fc = ((FunctionDefinition)nodeDef).getFunctionClassification();
                identifierIsLocalOrInstanceFunctionAsValue = (fc == IFunctionDefinition.FunctionClassification.LOCAL || fc == IFunctionDefinition.FunctionClassification.CLASS_MEMBER) && parentNodeId != ASTNodeID.MemberAccessExpressionID && parentNodeId != ASTNodeID.FunctionCallID;
            }
            boolean bl2 = generateClosure = parentNodeId == ASTNodeID.ContainerID && identifierIsPlainFunction && ((FunctionDefinition)nodeDef).getFunctionClassification() == IFunctionDefinition.FunctionClassification.CLASS_MEMBER || identifierIsLocalOrInstanceFunctionAsValue;
            if (generateClosure) {
                this.getEmitter().emitClosureStart();
            }
            boolean wroteSelf = false;
            if (EmitterUtils.writeThis(this.getProject(), this.getModel(), node)) {
                IFunctionObjectNode functionObjectNode = (IFunctionObjectNode)node.getParent().getAncestorOfType(IFunctionObjectNode.class);
                IFunctionNode functionNode = (IFunctionNode)node.getParent().getAncestorOfType(IFunctionNode.class);
                IFunctionDefinition functionDef = null;
                if (functionNode != null) {
                    functionDef = functionNode.getDefinition();
                }
                this.startMapping((ISourceLocation)node);
                if (functionObjectNode != null) {
                    this.write(JSGoogEmitterTokens.SELF);
                    wroteSelf = true;
                } else if (functionNode != null && functionDef.getFunctionClassification() == IFunctionDefinition.FunctionClassification.LOCAL) {
                    this.write(JSGoogEmitterTokens.SELF);
                    wroteSelf = true;
                } else {
                    this.write(ASEmitterTokens.THIS);
                }
                if (!isCustomNamespace) {
                    this.write(ASEmitterTokens.MEMBER_ACCESS);
                }
                this.endMapping((ISourceLocation)node);
            }
            if (generateClosure) {
                if (isCustomNamespace) {
                    ns = ((FunctionDefinition)nodeDef).getNamespaceReference().resolveAETNamespace(this.getProject());
                    INamespaceDefinition nsDef = ((FunctionDefinition)nodeDef).getNamespaceReference().resolveNamespaceReference(this.getProject());
                    fjs.formatQualifiedName(nsDef.getQualifiedName());
                    String nsName = ns.getName();
                    this.write("[\"" + nsName + "::" + node.getName() + "\"]");
                } else {
                    this.write(node.getName());
                }
                this.writeToken(ASEmitterTokens.COMMA);
                if (wroteSelf) {
                    this.write(JSGoogEmitterTokens.SELF);
                } else {
                    this.write(ASEmitterTokens.THIS);
                }
                this.getEmitter().emitClosureEnd((IASNode)node, nodeDef);
                emitName = false;
            }
        }
        if (emitName) {
            if (nodeDef != null) {
                IFunctionDefinition func;
                IVariableDefinition.VariableClassification classification;
                String qname = nodeDef.getQualifiedName();
                boolean isPackageOrFileMember = false;
                if (nodeDef instanceof IVariableDefinition) {
                    IVariableDefinition variable = (IVariableDefinition)nodeDef;
                    classification = variable.getVariableClassification();
                    if (classification == IVariableDefinition.VariableClassification.PACKAGE_MEMBER || classification == IVariableDefinition.VariableClassification.FILE_MEMBER) {
                        isPackageOrFileMember = true;
                    }
                } else if (nodeDef instanceof IFunctionDefinition && ((classification = (func = (IFunctionDefinition)nodeDef).getFunctionClassification()) == IFunctionDefinition.FunctionClassification.PACKAGE_MEMBER || classification == IFunctionDefinition.FunctionClassification.FILE_MEMBER)) {
                    isPackageOrFileMember = true;
                }
                boolean needsFormattedName = false;
                if (isPackageOrFileMember && parentNodeId == ASTNodeID.MemberAccessExpressionID) {
                    IMemberAccessExpressionNode parentMemberAccessNode = (IMemberAccessExpressionNode)parentNode;
                    needsFormattedName = parentMemberAccessNode.getLeftOperandNode() == node;
                }
                this.startMapping((ISourceLocation)node);
                if (parentNodeId == ASTNodeID.MemberAccessExpressionID) {
                    if (needsFormattedName) {
                        this.write(this.getEmitter().formatQualifiedName(qname));
                    } else if (isCustomNamespace) {
                        ns = ((FunctionDefinition)nodeDef).getNamespaceReference().resolveAETNamespace(this.getProject()).getName();
                        this.write("[\"" + (String)ns + "::" + qname + "\"]");
                    } else if (identifierIsAccessorFunction && isStatic) {
                        this.write("[\"" + node.getName() + "\"]");
                    } else {
                        this.write(node.getName());
                    }
                } else if (isPackageOrFileMember) {
                    this.write(this.getEmitter().formatQualifiedName(qname));
                } else if (nodeDef instanceof TypeDefinitionBase) {
                    this.write(this.getEmitter().formatQualifiedName(qname));
                } else if (isCustomNamespace) {
                    ns = ((FunctionDefinition)nodeDef).getNamespaceReference().resolveAETNamespace(this.getProject()).getName();
                    this.write("[\"" + (String)ns + "::" + qname + "\"]");
                } else if (identifierIsAccessorFunction && isStatic) {
                    this.write("[\"" + qname + "\"]");
                } else {
                    this.write(qname);
                }
                this.endMapping((ISourceLocation)node);
            } else if (grandparentNodeId == ASTNodeID.E4XFilterID && parentNodeId != ASTNodeID.MemberAccessExpressionID && parentNodeId != ASTNodeID.Op_DescendantsID) {
                this.startMapping((ISourceLocation)node);
                this.write("child('");
                this.write(node.getName());
                this.write("')");
                this.endMapping((ISourceLocation)node);
            } else {
                this.startMapping((ISourceLocation)node);
                this.write(node.getName());
                this.endMapping((ISourceLocation)node);
            }
        }
    }
}

