/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.io;

import flex.messaging.io.PropertyProxy;
import flex.messaging.io.PropertyProxyRegistry;
import flex.messaging.io.SerializationDescriptor;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;

public class ArrayCollection
extends ArrayList
implements Externalizable {
    private static final long serialVersionUID = 8037277879661457358L;
    private SerializationDescriptor descriptor = null;

    public ArrayCollection() {
    }

    public ArrayCollection(Collection c) {
        super(c);
    }

    public ArrayCollection(int initialCapacity) {
        super(initialCapacity);
    }

    public Object[] getSource() {
        return this.toArray();
    }

    public void setDescriptor(SerializationDescriptor desc) {
        this.descriptor = desc;
    }

    public void setSource(Object[] s) {
        if (s == null) {
            this.clear();
            return;
        }
        if (this.size() > 0) {
            this.clear();
        }
        for (int i = 0; i < s.length; ++i) {
            this.add(s[i]);
        }
    }

    public void setSource(Collection s) {
        this.addAll(s);
    }

    @Override
    public void readExternal(ObjectInput input) throws IOException, ClassNotFoundException {
        Object[] s = input.readObject();
        if (s instanceof Collection) {
            s = ((Collection)s).toArray();
        }
        Object[] source = s;
        this.setSource(source);
    }

    @Override
    public void writeExternal(ObjectOutput output) throws IOException {
        if (this.descriptor == null) {
            output.writeObject(this.getSource());
            return;
        }
        Object[] source = this.getSource();
        if (source == null) {
            output.writeObject(null);
            return;
        }
        for (int i = 0; i < source.length; ++i) {
            Object item = source[i];
            if (item == null) {
                source[i] = null;
                continue;
            }
            PropertyProxy proxy = PropertyProxyRegistry.getProxy(item);
            proxy = (PropertyProxy)proxy.clone();
            proxy.setDescriptor(this.descriptor);
            proxy.setDefaultInstance(item);
            source[i] = proxy;
        }
        output.writeObject(source);
    }
}

