/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.services.http;

import flex.messaging.config.ConfigMap;
import flex.messaging.messages.Message;
import flex.messaging.services.ServiceAdapter;
import flex.messaging.services.ServiceException;
import flex.messaging.services.http.ExternalProxySettings;
import flex.messaging.services.http.HTTPConnectionManagerSettings;
import flex.messaging.services.http.HostConfigurationSettings;
import flex.messaging.services.http.ProtocolFactory;
import flex.messaging.util.ClassUtil;
import java.util.ArrayList;
import java.util.List;

public class HTTPProxyAdapter
extends ServiceAdapter {
    public static final String CONTENT_TYPE_XML = "application/xml";
    public static final String CONTENT_TYPE_FORM = "application/x-www-form-urlencoded";
    public static final int DEFAULT_COOKIE_LIMIT = 200;
    private static final String COOKIE_LIMIT = "cookie-limit";
    private static final String ALLOW_LAX_SSL = "allow-lax-ssl";
    private static final String CONTENT_CHUNKED = "content-chunked";
    private static final String ID = "id";
    private static final String CLASS = "class";
    private static final String PROPERTIES = "properties";
    private static final String REQUEST_HEADERS = "requestHeaders";
    private static final String RESPONSE_HEADERS = "responseHeaders";
    protected boolean allowLaxSSL = false;
    protected boolean contentChunked = false;
    protected int cookieLimit = 200;
    protected ExternalProxySettings externalProxy = new ExternalProxySettings();
    protected HTTPConnectionManagerSettings connectionManagerSettings = new HTTPConnectionManagerSettings();

    public HTTPProxyAdapter() {
        this(false);
    }

    public HTTPProxyAdapter(boolean enableManagement) {
        super(enableManagement);
    }

    public void initialize(String id, ConfigMap properties) {
        ConfigMap extern;
        super.initialize(id, properties);
        if (properties == null || properties.size() == 0) {
            return;
        }
        ConfigMap conn = properties.getPropertyAsMap("connection-manager", null);
        if (conn != null) {
            List hosts;
            if (conn.getProperty("cookie-policy") != null) {
                // empty if block
            }
            if (conn.getProperty("max-total-connections") != null) {
                // empty if block
            }
            if (conn.getProperty("default-max-connections-per-host") != null) {
                // empty if block
            }
            if (conn.getProperty("connection-timeout") != null) {
                // empty if block
            }
            if (conn.getProperty("socket-timeout") != null) {
                // empty if block
            }
            if (conn.getProperty("stale-checking-enabled") != null) {
                // empty if block
            }
            if (conn.getProperty("send-buffer-size") != null) {
                // empty if block
            }
            if (conn.getProperty("receive-buffer-size") != null) {
                // empty if block
            }
            if (conn.getProperty("tcp-no-delay") != null) {
                // empty if block
            }
            if (conn.getProperty("linger") != null) {
                // empty if block
            }
            if ((hosts = conn.getPropertyAsList("max-per-host", null)) != null) {
                ArrayList<HostConfigurationSettings> hostSettings = new ArrayList<HostConfigurationSettings>();
                for (ConfigMap maxPerHost : hosts) {
                    ConfigMap proxy;
                    HostConfigurationSettings hostConfig = new HostConfigurationSettings();
                    if (maxPerHost.getProperty("max-connections") != null) {
                        // empty if block
                    }
                    if (maxPerHost.getProperty("host") != null) {
                        String host = maxPerHost.getPropertyAsString("host", null);
                        hostConfig.setHost(host);
                        if (host != null) {
                            int port = maxPerHost.getPropertyAsInt("port", 0);
                            hostConfig.setPort(port);
                            ConfigMap factoryMap = maxPerHost.getPropertyAsMap("protocol-factory", null);
                            if (factoryMap != null) {
                                String className = factoryMap.getPropertyAsString(CLASS, null);
                                if (className != null) {
                                    Class factoryClass = ClassUtil.createClass((String)className);
                                    ProtocolFactory protocolFactory = (ProtocolFactory)ClassUtil.createDefaultInstance((Class)factoryClass, ProtocolFactory.class);
                                    String factoryId = factoryMap.getPropertyAsString(ID, host + "_protocol_factory");
                                    ConfigMap protocolProperties = factoryMap.getPropertyAsMap(PROPERTIES, null);
                                    protocolFactory.initialize(factoryId, protocolProperties);
                                }
                            } else {
                                String protocol = maxPerHost.getPropertyAsString("protocol", null);
                                hostConfig.setProtocol(protocol);
                            }
                        }
                    }
                    if ((proxy = maxPerHost.getPropertyAsMap("proxy", null)) != null) {
                        String proxyHost = proxy.getPropertyAsString("host", null);
                        hostConfig.setProxyHost(proxyHost);
                        if (proxyHost != null) {
                            int port = proxy.getPropertyAsInt("port", 0);
                            hostConfig.setProxyPort(port);
                        }
                    }
                    if (maxPerHost.getProperty("local-address") != null) {
                        String localAddress = maxPerHost.getPropertyAsString("local-address", null);
                        hostConfig.setLocalAddress(localAddress);
                    }
                    if (maxPerHost.getProperty("virtual-host") != null) {
                        String virtualHost = maxPerHost.getPropertyAsString("virtual-host", null);
                        hostConfig.setVirtualHost(virtualHost);
                    }
                    hostSettings.add(hostConfig);
                }
                if (hostSettings.size() > 0) {
                    this.connectionManagerSettings.setMaxConnectionsPerHost(hostSettings);
                }
            }
        }
        if (properties.getProperty(COOKIE_LIMIT) != null) {
            // empty if block
        }
        if (properties.getProperty(ALLOW_LAX_SSL) != null) {
            // empty if block
        }
        if (properties.getProperty(CONTENT_CHUNKED) != null) {
            // empty if block
        }
        if ((extern = properties.getPropertyAsMap("external-proxy", null)) != null) {
            // empty if block
        }
    }

    public Object invoke(Message msg) {
        ServiceException e = new ServiceException();
        e.setMessage("flex.messaging.services.http.HTTPProxyAdapter is no longer supported by BlazeDS");
        throw e;
    }
}

