/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.util.graph;

import flex2.compiler.util.graph.Edge;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Vertex<VertexWeight, EdgeWeight> {
    private static final int INITIAL_CAPACITY = 5;
    private VertexWeight weight;
    int id;
    private Set<Edge<VertexWeight, EdgeWeight>> incidentEdges;
    private Set<Edge<VertexWeight, EdgeWeight>> emanatingEdges;
    private Set<Vertex<VertexWeight, EdgeWeight>> predecessors;
    private List<Vertex<VertexWeight, EdgeWeight>> successors;

    public Vertex(VertexWeight weight) {
        this.weight = weight;
    }

    public VertexWeight getWeight() {
        return this.weight;
    }

    public void addIncidentEdge(Edge<VertexWeight, EdgeWeight> e) {
        if (this.incidentEdges == null) {
            this.incidentEdges = new HashSet<Edge<VertexWeight, EdgeWeight>>(5);
        }
        this.incidentEdges.add(e);
    }

    public void removeIncidentEdge(Edge<VertexWeight, EdgeWeight> e) {
        if (this.incidentEdges != null) {
            this.incidentEdges.remove(e);
        }
    }

    public Set<Edge<VertexWeight, EdgeWeight>> getIncidentEdges() {
        return this.incidentEdges;
    }

    public void addEmanatingEdge(Edge<VertexWeight, EdgeWeight> e) {
        if (this.emanatingEdges == null) {
            this.emanatingEdges = new HashSet<Edge<VertexWeight, EdgeWeight>>(5);
        }
        this.emanatingEdges.add(e);
    }

    public void removeEmanatingEdge(Edge<VertexWeight, EdgeWeight> e) {
        if (this.emanatingEdges != null) {
            this.emanatingEdges.remove(e);
        }
    }

    public Set<Edge<VertexWeight, EdgeWeight>> getEmanatingEdges() {
        return this.emanatingEdges;
    }

    public void addPredecessor(Vertex<VertexWeight, EdgeWeight> v) {
        if (this.predecessors == null) {
            this.predecessors = new HashSet<Vertex<VertexWeight, EdgeWeight>>(5);
        }
        this.predecessors.add(v);
    }

    public void removePredecessor(Vertex<VertexWeight, EdgeWeight> v) {
        if (this.predecessors != null) {
            this.predecessors.remove(v);
        }
    }

    public Set<Vertex<VertexWeight, EdgeWeight>> getPredecessors() {
        return this.predecessors;
    }

    public void addSuccessor(Vertex<VertexWeight, EdgeWeight> v) {
        if (this.successors == null) {
            this.successors = new ArrayList<Vertex<VertexWeight, EdgeWeight>>(5);
        }
        this.successors.add(v);
    }

    public void removeSuccessor(Vertex<VertexWeight, EdgeWeight> v) {
        if (this.successors != null) {
            this.successors.remove(v);
        }
    }

    public List<Vertex<VertexWeight, EdgeWeight>> getSuccessors() {
        return this.successors;
    }

    public int inDegrees() {
        return this.incidentEdges == null ? 0 : this.incidentEdges.size();
    }

    public int outDegrees() {
        return this.emanatingEdges == null ? 0 : this.emanatingEdges.size();
    }

    public boolean equals(Object object) {
        if (object instanceof Vertex) {
            return this.weight == null ? super.equals(object) : this.weight.equals(((Vertex)object).weight);
        }
        return false;
    }

    public int hashCode() {
        return this.weight != null ? this.weight.hashCode() : super.hashCode();
    }
}

