/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.maven.osgicheck.impl.checks;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import org.apache.felix.maven.osgicheck.impl.Check;
import org.apache.felix.maven.osgicheck.impl.CheckContext;
import org.apache.felix.scr.impl.helper.Logger;
import org.apache.felix.scr.impl.metadata.ComponentMetadata;
import org.apache.felix.scr.impl.metadata.ReferenceMetadata;
import org.apache.felix.scr.impl.parser.KXml2SAXHandler;
import org.apache.felix.scr.impl.parser.KXml2SAXParser;
import org.apache.felix.scr.impl.xml.XmlHandler;
import org.apache.maven.plugin.MojoExecutionException;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.service.component.ComponentException;

public class SCRCheck
implements Check {
    @Override
    public String getName() {
        return "scr";
    }

    @Override
    public void check(CheckContext ctx) throws IOException, MojoExecutionException {
        ctx.getLog().info((CharSequence)"Checking for SCR descriptor...");
        String val = ctx.getManifest().getMainAttributes().getValue("Service-Component");
        if (val != null) {
            String[] components;
            for (String cmp : components = val.split(",")) {
                File xmlFile = new File(ctx.getRootDir(), cmp.trim().replace('/', File.separatorChar));
                if (!xmlFile.exists()) {
                    throw new MojoExecutionException("SCR descriptor file '" + cmp + "' not found in bundle");
                }
                List<ComponentMetadata> mList = this.loadDescriptor(ctx, xmlFile);
                for (ComponentMetadata md : mList) {
                    this.check(ctx, md);
                }
            }
        }
    }

    private void check(CheckContext ctx, ComponentMetadata md) {
        this.checkImmediate(ctx, md);
        this.checkGreedyReferences(ctx, md);
        this.checkMultiReferencesLast(ctx, md);
    }

    private void checkImmediate(CheckContext ctx, ComponentMetadata md) {
        Boolean immediate = null;
        try {
            Field immediateField = md.getClass().getDeclaredField("m_immediate");
            immediateField.setAccessible(true);
            immediate = (Boolean)immediateField.get(md);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new RuntimeException(e);
        }
        if (md.getServiceMetadata() == null) {
            if (immediate != null) {
                if (immediate.booleanValue()) {
                    ctx.reportError("Component " + md.getName() + " must not be declared as 'immediate'. It's a component. Remove the attribute.");
                } else {
                    ctx.reportError("Component " + md.getName() + " must not be declared as not 'immediate'.It's a component. Remove the attribute.");
                }
            }
        } else if (immediate != null) {
            if (immediate.booleanValue()) {
                ctx.reportWarning("Service " + md.getName() + " should not be declared as 'immediate'.");
            } else {
                ctx.reportWarning("Service " + md.getName() + " should not declare 'immediate' attribute but rather use the default.");
            }
        }
    }

    private void checkGreedyReferences(CheckContext ctx, ComponentMetadata md) {
        for (ReferenceMetadata rmd : md.getDependencies()) {
            if (rmd.isMultiple() || !rmd.isReluctant()) continue;
            ctx.reportWarning("Component " + md.getName() + " should use greedy for reference " + rmd.getName());
        }
    }

    private void checkMultiReferencesLast(CheckContext ctx, ComponentMetadata md) {
        boolean reachedMulti = false;
        for (ReferenceMetadata rmd : md.getDependencies()) {
            if (!rmd.isMultiple()) {
                if (!reachedMulti) continue;
                ctx.reportWarning("Component " + md.getName() + " should put the following reference before the references with multiple cardinality " + rmd.getName());
                continue;
            }
            reachedMulti = true;
        }
    }

    private List<ComponentMetadata> loadDescriptor(final CheckContext ctx, final File file) throws IOException, MojoExecutionException {
        Throwable throwable = null;
        try (BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));){
            XmlHandler handler = new XmlHandler(new Bundle(){

                public int compareTo(Bundle o) {
                    return 0;
                }

                public void update(InputStream input) throws BundleException {
                }

                public void update() throws BundleException {
                }

                public void uninstall() throws BundleException {
                }

                public void stop(int options) throws BundleException {
                }

                public void stop() throws BundleException {
                }

                public void start(int options) throws BundleException {
                }

                public void start() throws BundleException {
                }

                public Class<?> loadClass(String name) throws ClassNotFoundException {
                    return null;
                }

                public boolean hasPermission(Object permission) {
                    return false;
                }

                public Version getVersion() {
                    return null;
                }

                public String getSymbolicName() {
                    return null;
                }

                public int getState() {
                    return 0;
                }

                public Map<X509Certificate, List<X509Certificate>> getSignerCertificates(int signersType) {
                    return null;
                }

                public ServiceReference<?>[] getServicesInUse() {
                    return null;
                }

                public Enumeration<URL> getResources(String name) throws IOException {
                    return null;
                }

                public URL getResource(String name) {
                    return null;
                }

                public ServiceReference<?>[] getRegisteredServices() {
                    return null;
                }

                public String getLocation() {
                    return file.getAbsolutePath();
                }

                public long getLastModified() {
                    return 0L;
                }

                public Dictionary<String, String> getHeaders(String locale) {
                    return null;
                }

                public Dictionary<String, String> getHeaders() {
                    return null;
                }

                public Enumeration<String> getEntryPaths(String path) {
                    return null;
                }

                public URL getEntry(String path) {
                    try {
                        return new File(ctx.getRootDir(), path).toURI().toURL();
                    }
                    catch (MalformedURLException e) {
                        return null;
                    }
                }

                public File getDataFile(String filename) {
                    return null;
                }

                public long getBundleId() {
                    return 0L;
                }

                public BundleContext getBundleContext() {
                    return null;
                }

                public Enumeration<URL> findEntries(String path, String filePattern, boolean recurse) {
                    return null;
                }

                public <A> A adapt(Class<A> type) {
                    return null;
                }
            }, new Logger(){

                public void log(int level, String pattern, Object[] arguments, ComponentMetadata metadata, Long componentId, Throwable ex) {
                }

                public void log(int level, String message, ComponentMetadata metadata, Long componentId, Throwable ex) {
                }

                public boolean isLogEnabled(int level) {
                    return false;
                }
            }, false, false);
            try {
                new KXml2SAXParser((Reader)in).parseXML((KXml2SAXHandler)handler);
                for (ComponentMetadata metadata : handler.getComponentMetadataList()) {
                    try {
                        metadata.validate(null);
                    }
                    catch (ComponentException t) {
                        ctx.reportError("Invalid component descriptor " + file.getAbsolutePath() + " for " + metadata.getName() + " : " + t.getMessage());
                    }
                }
                List i$ = handler.getComponentMetadataList();
                return i$;
            }
            catch (Exception e) {
                try {
                    if (e instanceof MojoExecutionException) {
                        throw (MojoExecutionException)e;
                    }
                    throw new MojoExecutionException(e.getMessage(), e);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
    }
}

