/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.maven.osgicheck.impl.checks;

import java.util.List;
import org.apache.felix.maven.osgicheck.impl.Check;
import org.apache.felix.maven.osgicheck.impl.CheckContext;
import org.apache.felix.maven.osgicheck.impl.featureutil.ManifestUtil;
import org.apache.felix.maven.osgicheck.impl.featureutil.PackageInfo;
import org.apache.maven.plugin.MojoExecutionException;
import org.osgi.framework.Version;

public class ImportExportCheck
implements Check {
    @Override
    public String getName() {
        return "packages";
    }

    @Override
    public void check(CheckContext ctx) throws MojoExecutionException {
        ctx.getLog().info((CharSequence)"Checking bundle exports/imports...");
        List<PackageInfo> exp = ManifestUtil.extractExportedPackages(ctx.getManifest());
        for (PackageInfo p : exp) {
            if (p.getPackageVersion().compareTo(Version.emptyVersion) == 0) {
                ctx.reportError("Package is exported without version " + p.getName());
            }
            if (!p.getName().contains(".impl.") && !p.getName().contains(".internal.")) continue;
            ctx.reportWarning("Package seems to export a private package " + p.getName());
        }
        List<PackageInfo> imp = ManifestUtil.extractImportedPackages(ctx.getManifest());
        for (PackageInfo p : imp) {
            if (p.getVersion() != null) continue;
            ctx.reportWarning("Package is imported without version (range) " + p.getName());
        }
        List<PackageInfo> dynImp = ManifestUtil.extractDynamicImportedPackages(ctx.getManifest());
        for (PackageInfo p : dynImp) {
            if ("*".equals(p.getName())) {
                ctx.reportWarning("Dynamic package import * should be avoided");
                continue;
            }
            if (p.getVersion() != null) continue;
            ctx.reportWarning("Dynamic package is imported without version (range) " + p.getName());
        }
    }
}

